/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.util.Iterator;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class SignatureValidator {
    private File dir;

    public SignatureValidator(File file) {
        this.dir = file;
    }

    public boolean validate(String string, KeySelector keySelector) throws Exception {
        return this.validate(string, keySelector, null);
    }

    public DOMValidateContext getValidateContext(String string, KeySelector keySelector) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(this.dir, string));
        Element element = SignatureValidator.getSignatureElement(document);
        if (element == null) {
            throw new Exception("Couldn't find signature Element");
        }
        DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, (Node)element);
        dOMValidateContext.setBaseURI(this.dir.toURI().toString());
        return dOMValidateContext;
    }

    public boolean validate(String string, KeySelector keySelector, URIDereferencer uRIDereferencer) throws Exception {
        DOMValidateContext dOMValidateContext = this.getValidateContext(string, keySelector);
        if (uRIDereferencer != null) {
            dOMValidateContext.setURIDereferencer(uRIDereferencer);
        }
        return this.validate(dOMValidateContext);
    }

    public boolean validate(DOMValidateContext dOMValidateContext) throws Exception {
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
        boolean bl = xMLSignature.validate(dOMValidateContext);
        if (!bl) {
            Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Reference reference = iterator.next();
                reference.validate(dOMValidateContext);
                ++n;
            }
        }
        return bl;
    }

    public static Element getSignatureElement(Document document) {
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)document)).createNodeIterator(document.getDocumentElement(), 1, null, false);
        Node node = nodeIterator.nextNode();
        while (node != null) {
            if ("Signature".equals(node.getLocalName())) {
                return (Element)node;
            }
            node = nodeIterator.nextNode();
        }
        return null;
    }
}

