/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtLocation module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qgeomap_p.h"
#include "qgeomapdata_p.h"

#include "qgeotilecache_p.h"
#include "qgeotilespec_p.h"
#include "qgeoprojection_p.h"
#include "qgeocameracapabilities_p.h"
#include "qgeomapcontroller_p.h"
#include "qdoublevector2d_p.h"
#include "qdoublevector3d_p.h"

#include "qgeocameratiles_p.h"
#include "qgeotilerequestmanager_p.h"
#include "qgeomapscene_p.h"

#include "qgeomappingmanager_p.h"

#include <QMutex>
#include <QMap>

#include <qnumeric.h>

#include <Qt3D/qglscenenode.h>
#include <Qt3D/qgeometrydata.h>
#include <Qt3D/qglbuilder.h>
#include <Qt3D/qglpainter.h>
#include <Qt3D/qgeometrydata.h>
#include <Qt3D/qglbuilder.h>
#include <Qt3D/qglcamera.h>
#include <Qt3D/qglsubsurface.h>

#include <cmath>

QT_BEGIN_NAMESPACE

QGeoMap::QGeoMap(QGeoMapData *mapData, QObject *parent)
    : QObject(parent),
      mapData_(mapData)
{
    connect(mapData_, SIGNAL(cameraDataChanged(const QGeoCameraData&)), this, SIGNAL(cameraDataChanged(const QGeoCameraData&)));
    connect(mapData_, SIGNAL(updateRequired()), this, SIGNAL(updateRequired()));
    connect(mapData_, SIGNAL(activeMapTypeChanged()), this, SIGNAL(activeMapTypeChanged()));
    connect(mapData_, SIGNAL(copyrightsChanged(const QImage&, const QPoint&)), this, SIGNAL(copyrightsChanged(const QImage&, const QPoint&)));
}

QGeoMap::~QGeoMap()
{
    delete mapData_;
}

QGeoMapController *QGeoMap::mapController()
{
    return mapData_->mapController();
}

QGLCamera *QGeoMap::glCamera() const
{
    return mapData_->glCamera();
}

void QGeoMap::paintGL(QGLPainter *painter)
{
    mapData_->paintGL(painter);
}

void QGeoMap::resize(int width, int height)
{
    mapData_->resize(width, height);
}

int QGeoMap::width() const
{
    return mapData_->width();
}

int QGeoMap::height() const
{
    return mapData_->height();
}

QGeoCameraCapabilities QGeoMap::cameraCapabilities() const
{
    return mapData_->cameraCapabilities();
}

void QGeoMap::setCameraData(const QGeoCameraData &cameraData)
{
    mapData_->setCameraData(cameraData);
}

void QGeoMap::cameraStopped()
{
    mapData_->prefetchData();
}

QGeoCameraData QGeoMap::cameraData() const
{
    return mapData_->cameraData();
}

QGeoCoordinate QGeoMap::screenPositionToCoordinate(const QPointF &pos, bool clipToViewport) const
{
    return mapData_->screenPositionToCoordinate(pos, clipToViewport);
}

QPointF QGeoMap::coordinateToScreenPosition(const QGeoCoordinate &coordinate, bool clipToViewport) const
{
    return mapData_->coordinateToScreenPosition(coordinate, clipToViewport);
}

void QGeoMap::update()
{
    emit mapData_->update();
}

void QGeoMap::setActiveMapType(const QGeoMapType type)
{
    mapData_->setActiveMapType(type);
}

const QGeoMapType QGeoMap::activeMapType() const
{
    return mapData_->activeMapType();
}

QString QGeoMap::pluginString()
{
    return mapData_->pluginString();
}

QT_END_NAMESPACE
