/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Graphical Effects module.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
**     of its contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.0

Label {
    id: bgColorPicker
    property color color: "#242424"
    caption: "Background color"

    Row {
        id: selection
        x: -3
        y: 3
        spacing: 4
        Rectangle { width: 16; height: 16; color: "#ffffff"
            Image {
                anchors.centerIn: parent
                source: "images/color_selection_mask.png"
            }
            MouseArea {
                anchors.fill: parent
                anchors.margins: -3
                onClicked: {
                    bgColorPicker.color = parent.color
                    highlight.x = parent.x - 3
                }
            }
        }
        Rectangle { width: 16; height: 16; color: "#ababab"
            Image {
                anchors.centerIn: parent
                source: "images/color_selection_mask.png"
            }
            MouseArea {
                anchors.fill: parent
                anchors.margins: -3
                onClicked: {
                    bgColorPicker.color = parent.color
                    highlight.x = parent.x - 3
                }
            }
        }
        Rectangle { id: initial; width: 16; height: 16; color: "#242424"
            Image {
                anchors.centerIn: parent
                source: "images/color_selection_mask.png"
            }
            MouseArea {
                anchors.fill: parent
                anchors.margins: -3
                onClicked: {
                    bgColorPicker.color = parent.color
                    highlight.x = parent.x - 3
                }
            }
        }
        Rectangle { width: 16; height: 16; color: "#000000"
            Image {
                anchors.centerIn: parent
                source: "images/color_selection_mask.png"
            }
            MouseArea {
                anchors.fill: parent
                anchors.margins: -3
                onClicked: {
                    bgColorPicker.color = parent.color
                    highlight.x = parent.x - 3
                }
            }
        }
        Image { source: "images/background.png"
            width: 16; height: 16;
            Image {
                anchors.centerIn: parent
                source: "images/color_selection_mask.png"
            }
            MouseArea {
                anchors.fill: parent
                anchors.margins: -3
                onClicked: {
                    bgColorPicker.color = "#010101"
                    highlight.x = parent.x - 3
                }
            }
        }
    }

    Image {
        id: highlight
        source: "images/color_selection_hl.png"
        x: initial.x - (highlight.width - initial.width) * 0.5
        y: selection.y - (highlight.height - selection.height) * 0.5
    }
}
