# Объект Route

**Объект Route** содержит состояние текущего активного пути, а именно: структурированную информацию о текущем URL и **записи путей**, совпавшие с ним.

Объект пути иммутабелен: при каждом навигационном переходе он пересоздаётся заново.

Объекты пути могут быть обнаружены в нескольких местах:

- В компонентах, в виде `this.$route`

- В коллбэках при отслеживании `$route`

- Как возвращаемое значение при вызове `router.match(location)`

- В качестве первых двух параметров сторожевых хуков:

  ``` js
  router.beforeEach((to, from, next) => {
    // как `to` так и `from` являются объектами пути
  })
  ```

- В качестве первых двух параметров функции `scrollBehavior` :

  ``` js
  const router = new VueRouter({
    scrollBehavior (to, from, savedPosition) {
      // как `to` так и `from` являются объектами пути
    }
  })
  ```

### Свойства объекта Route

- **$route.path**

  - тип: `string`

    Строковое значение path текущего пути, всегда в абсолютном формате, напр. `"/foo/bar"`.

- **$route.params**

  - тип: `Object`

    Объект, содержащий пары ключ/значение для динамических сегментов (включая *-сегменты). Будет пустым, если параметров у пути нет.

- **$route.query**

  - тип: `Object`

    Объект, содержащий пары ключ/значение для строки запроса (query string). Например, для пути `/foo?user=1` получится `$route.query.user == 1`. При отсутствии строки запроса, будет пустым объектом.

- **$route.hash**

  - тип: `string`

    Хэш текущего пути (с символом `#`), если присутствует. В противном случае — пустая строка.

- **$route.fullPath**

  - тип: `string`

    Полная запись URL, включая строку запроса и хэш.

- **$route.matched**

  - тип: `Array<RouteRecord>`

  Массив, содержащий **записи путей** для всех вложенных сегментов текущего пути. Записи путей — это копии объектов конфигурации из массива `routes` (и вложенных массивов `children`):

  ``` js
  const router = new VueRouter({
    routes: [
      // объект ниже — это запись пути
      { path: '/foo', component: Foo,
        children: [
          // это — тоже запись пути
          { path: 'bar', component: Bar }
        ]
      }
    ]
  })
  ```

  Для URL, равного `/foo/bar`, `$route.matched` будет массивом, содержащим копии обоих объектов, в порядке сортировки от родителя к потомку.

- **$route.name**

  Имя текущего пути, если указано. (См. [Именованные пути](../essentials/named-routes.md))
