/*
 * $Id: AbstractGraph.java,v 1.3 2007-03-11 20:40:58 larry Exp $ 
 */
package com.representqueens.web.tags.spark;

/*
 * 
 * Copyright 2006 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

import javax.servlet.jsp.tagext.TagSupport;

import com.representqueens.spark.BarGraph;
import com.representqueens.spark.Encoder;
import com.representqueens.spark.LineGraph;
import com.representqueens.spark.SizeParams;
import com.representqueens.spark.Encoder.Format;
import com.representqueens.spark.util.StringConversion;
import com.representqueens.util.StringUtils;

/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.3 $ $Date: 2007-03-11 20:40:58 $
 */
public abstract class AbstractGraph extends TagSupport
{
  private String name;
  private String width;
  private String height;
  private String spacing;
  private String color;
  private String highColor;
  private String lastColor;
  private String background;
  
  private String output;

  public String getColor()
  {
    return this.color;
  }

  public void setColor(final String color)
  {
    this.color = color;
  }

  public String getHeight()
  {
    return this.height;
  }

  public void setHeight(final String height)
  {
    this.height = height;
  }

  public String getName()
  {
    return this.name;
  }

  public void setName(final String name)
  {
    this.name = name;
  }

  public String getOutput()
  {
    return this.output;
  }

  public void setOutput(final String output)
  {
    this.output = output;
  }

  public String getSpacing()
  {
    return this.spacing;
  }

  public void setSpacing(final String spacing)
  {
    this.spacing = spacing;
  }

  public String getWidth()
  {
    return this.width;
  }

  public void setWidth(final String width)
  {
    this.width = width;
  }

  public String getHighColor()
  {
    return this.highColor;
  }

  public void setHighColor(final String highColor)
  {
    this.highColor = highColor;
  }

  public String getLastColor()
  {
    return this.lastColor;
  }

  public void setLastColor(final String lastColor)
  {
    this.lastColor = lastColor;
  }
  
  
  public String getBackground()
  {
    return this.background;
  }
  
  public void setBackground(final String background)
  {
    this.background = background;
  }
  
  protected String getBarGraphData() throws IOException
  {
    final BufferedImage image =
      BarGraph.createGraph(getData(),
                           getSizeParams(BarGraph.DEFAULT_SIZE),
                           StringConversion.convertColor(this.color, BarGraph.DEFAULT_COLOR),
                           StringConversion.convertColor(this.highColor, null),
                           StringConversion.convertColor(this.lastColor, null));
    
    return Encoder.encode(image, getOutputFormat());
  }
  
  protected String getLineGraphData() throws IOException
  {
    final BufferedImage image =
      LineGraph.createGraph(getData(),
                            getSizeParams(LineGraph.DEFAULT_SIZE),
                            StringConversion.convertColor(this.color, LineGraph.DEFAULT_COLOR));
    
    return Encoder.encode(image, getOutputFormat());
  }
  
  protected SizeParams getSizeParams(final SizeParams defaults)
  {
    return new SizeParams(StringConversion.convertInt(this.width, defaults.getWidth()),
                          StringConversion.convertInt(this.height, defaults.getHeight()),
                          StringConversion.convertInt(this.spacing, defaults.getSpacing()));
  }
  
  protected Number[] getData()
  {
    final Object o = this.pageContext.findAttribute(this.name);
    
    if (o instanceof List)
    {
      final List l = (List) o;
      return (Number[]) l.toArray(new Number[l.size()]);
    }
    
    if (o instanceof Number[])
    {
      return (Number[]) o;
    }
    
    if (o instanceof String)
    {
      try
      {
        final List<Integer> l = StringUtils.toIntList((String) o);
        return l.toArray(new Number[l.size()]);
      }
      catch (final NumberFormatException nfe)
      {
        // fall through...
      }
    }
    
    return new Number[0];
  }
  
  protected Format getOutputFormat()
  {
    if (! StringUtils.isEmpty(this.output))
    {
      if ("data".equalsIgnoreCase(this.output))
      {
        return Format.DATA;
      }
    }
    
    return Format.JAVASCRIPT;
  }
}
