/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public class SHA5
extends MessageDigestSpi
implements Cloneable {
    private static final int LENGTH = 64;
    private static final long[] INITIAL_HASHES = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final int ITERATION = 80;
    private static final long[] ROUND_CONSTS = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private final long COUNT_MASK = 127L;
    private long[] W = new long[80];
    private long count = 0L;
    private long AA;
    private long BB;
    private long CC;
    private long DD;
    private long EE;
    private long FF;
    private long GG;
    private long HH;

    private static long lf_ch(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long lf_maj(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    private static long lf_R(long l, int n) {
        return l >>> n;
    }

    private static long lf_S(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private static long lf_sigma0(long l) {
        return SHA5.lf_S(l, 28) ^ SHA5.lf_S(l, 34) ^ SHA5.lf_S(l, 39);
    }

    private static long lf_sigma1(long l) {
        return SHA5.lf_S(l, 14) ^ SHA5.lf_S(l, 18) ^ SHA5.lf_S(l, 41);
    }

    private static long lf_delta0(long l) {
        return SHA5.lf_S(l, 1) ^ SHA5.lf_S(l, 8) ^ SHA5.lf_R(l, 7);
    }

    private static long lf_delta1(long l) {
        return SHA5.lf_S(l, 19) ^ SHA5.lf_S(l, 61) ^ SHA5.lf_R(l, 6);
    }

    SHA5(SHA5 sHA5) {
        this();
        System.arraycopy(sHA5.W, 0, this.W, 0, this.W.length);
        this.count = sHA5.count;
        this.AA = sHA5.AA;
        this.BB = sHA5.BB;
        this.CC = sHA5.CC;
        this.DD = sHA5.DD;
        this.EE = sHA5.EE;
        this.FF = sHA5.FF;
        this.GG = sHA5.GG;
        this.HH = sHA5.HH;
    }

    public SHA5() {
        this.init();
    }

    protected int engineGetDigestLength() {
        return 64;
    }

    protected void engineUpdate(byte by) {
        this.update(by);
    }

    private void update(int n) {
        int n2 = (int)(this.count & 0x7FL) >>> 3;
        int n3 = (int)((this.count ^ 0xFFFFFFFFFFFFFFFFL) & 7L) << 3;
        this.W[n2] = this.W[n2] & (255L << n3 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)n & 0xFFL) << n3;
        ++this.count;
        if ((this.count & 0x7FL) == 0L) {
            this.computeBlock();
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (n2 > 0 && (this.count & 7L) != 0L) {
            this.engineUpdate(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 >= 8) {
            int n3 = (int)(this.count & 0x7FL) >> 3;
            this.W[n3] = ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
            this.count += 8L;
            if ((this.count & 0x7FL) == 0L) {
                this.computeBlock();
            }
            n2 -= 8;
            n += 8;
        }
        while (n2 > 0) {
            this.engineUpdate(byArray[n++]);
            --n2;
        }
    }

    void init() {
        this.setInitialHash(INITIAL_HASHES);
        for (int i = 0; i < 80; ++i) {
            this.W[i] = 0L;
        }
        this.count = 0L;
    }

    void setInitialHash(long[] lArray) {
        this.AA = lArray[0];
        this.BB = lArray[1];
        this.CC = lArray[2];
        this.DD = lArray[3];
        this.EE = lArray[4];
        this.FF = lArray[5];
        this.GG = lArray[6];
        this.HH = lArray[7];
    }

    protected void engineReset() {
        this.init();
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[64];
        try {
            int n = this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw new InternalError("");
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 64) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < 64) {
            throw new DigestException("output buffer too small to store the digest");
        }
        this.performDigest(byArray, n, 64);
        return 64;
    }

    void performDigest(byte[] byArray, int n, int n2) throws DigestException {
        long l = this.count << 3;
        this.update(128);
        while ((int)(this.count & 0x7FL) != 112) {
            this.update(0);
        }
        this.W[14] = 0L;
        this.W[15] = l;
        this.count += 16L;
        this.computeBlock();
        switch (n2) {
            case 64: {
                byArray[n + 63] = (byte)(this.HH >>> 0);
                byArray[n + 62] = (byte)(this.HH >>> 8);
                byArray[n + 61] = (byte)(this.HH >>> 16);
                byArray[n + 60] = (byte)(this.HH >>> 24);
                byArray[n + 59] = (byte)(this.HH >>> 32);
                byArray[n + 58] = (byte)(this.HH >>> 40);
                byArray[n + 57] = (byte)(this.HH >>> 48);
                byArray[n + 56] = (byte)(this.HH >>> 56);
                byArray[n + 55] = (byte)(this.GG >>> 0);
                byArray[n + 54] = (byte)(this.GG >>> 8);
                byArray[n + 53] = (byte)(this.GG >>> 16);
                byArray[n + 52] = (byte)(this.GG >>> 24);
                byArray[n + 51] = (byte)(this.GG >>> 32);
                byArray[n + 50] = (byte)(this.GG >>> 40);
                byArray[n + 49] = (byte)(this.GG >>> 48);
                byArray[n + 48] = (byte)(this.GG >>> 56);
            }
            case 48: {
                byArray[n + 47] = (byte)(this.FF >>> 0);
                byArray[n + 46] = (byte)(this.FF >>> 8);
                byArray[n + 45] = (byte)(this.FF >>> 16);
                byArray[n + 44] = (byte)(this.FF >>> 24);
                byArray[n + 43] = (byte)(this.FF >>> 32);
                byArray[n + 42] = (byte)(this.FF >>> 40);
                byArray[n + 41] = (byte)(this.FF >>> 48);
                byArray[n + 40] = (byte)(this.FF >>> 56);
                byArray[n + 39] = (byte)(this.EE >>> 0);
                byArray[n + 38] = (byte)(this.EE >>> 8);
                byArray[n + 37] = (byte)(this.EE >>> 16);
                byArray[n + 36] = (byte)(this.EE >>> 24);
                byArray[n + 35] = (byte)(this.EE >>> 32);
                byArray[n + 34] = (byte)(this.EE >>> 40);
                byArray[n + 33] = (byte)(this.EE >>> 48);
                byArray[n + 32] = (byte)(this.EE >>> 56);
                byArray[n + 31] = (byte)(this.DD >>> 0);
                byArray[n + 30] = (byte)(this.DD >>> 8);
                byArray[n + 29] = (byte)(this.DD >>> 16);
                byArray[n + 28] = (byte)(this.DD >>> 24);
                byArray[n + 27] = (byte)(this.DD >>> 32);
                byArray[n + 26] = (byte)(this.DD >>> 40);
                byArray[n + 25] = (byte)(this.DD >>> 48);
                byArray[n + 24] = (byte)(this.DD >>> 56);
                byArray[n + 23] = (byte)(this.CC >>> 0);
                byArray[n + 22] = (byte)(this.CC >>> 8);
                byArray[n + 21] = (byte)(this.CC >>> 16);
                byArray[n + 20] = (byte)(this.CC >>> 24);
                byArray[n + 19] = (byte)(this.CC >>> 32);
                byArray[n + 18] = (byte)(this.CC >>> 40);
                byArray[n + 17] = (byte)(this.CC >>> 48);
                byArray[n + 16] = (byte)(this.CC >>> 56);
                byArray[n + 15] = (byte)(this.BB >>> 0);
                byArray[n + 14] = (byte)(this.BB >>> 8);
                byArray[n + 13] = (byte)(this.BB >>> 16);
                byArray[n + 12] = (byte)(this.BB >>> 24);
                byArray[n + 11] = (byte)(this.BB >>> 32);
                byArray[n + 10] = (byte)(this.BB >>> 40);
                byArray[n + 9] = (byte)(this.BB >>> 48);
                byArray[n + 8] = (byte)(this.BB >>> 56);
                byArray[n + 7] = (byte)(this.AA >>> 0);
                byArray[n + 6] = (byte)(this.AA >>> 8);
                byArray[n + 5] = (byte)(this.AA >>> 16);
                byArray[n + 4] = (byte)(this.AA >>> 24);
                byArray[n + 3] = (byte)(this.AA >>> 32);
                byArray[n + 2] = (byte)(this.AA >>> 40);
                byArray[n + 1] = (byte)(this.AA >>> 48);
                byArray[n + 0] = (byte)(this.AA >>> 56);
                break;
            }
            default: {
                throw new DigestException("Unsupported Digest Length!");
            }
        }
        this.engineReset();
    }

    private void computeBlock() {
        int n;
        for (n = 16; n < 80; ++n) {
            this.W[n] = SHA5.lf_delta1(this.W[n - 2]) + this.W[n - 7] + SHA5.lf_delta0(this.W[n - 15]) + this.W[n - 16];
        }
        long l = this.AA;
        long l2 = this.BB;
        long l3 = this.CC;
        long l4 = this.DD;
        long l5 = this.EE;
        long l6 = this.FF;
        long l7 = this.GG;
        long l8 = this.HH;
        for (n = 0; n < 80; ++n) {
            long l9 = l8 + SHA5.lf_sigma1(l5) + SHA5.lf_ch(l5, l6, l7) + ROUND_CONSTS[n] + this.W[n];
            long l10 = SHA5.lf_sigma0(l) + SHA5.lf_maj(l, l2, l3);
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4 + l9;
            l4 = l3;
            l3 = l2;
            l2 = l;
            l = l9 + l10;
        }
        this.AA += l;
        this.BB += l2;
        this.CC += l3;
        this.DD += l4;
        this.EE += l5;
        this.FF += l6;
        this.GG += l7;
        this.HH += l8;
    }

    public Object clone() {
        SHA5 sHA5 = null;
        sHA5 = new SHA5(this);
        return sHA5;
    }
}

