/*
 * @(#)XMLFileParserUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.autodoc.v1.xml;

import net.sourceforge.groboutils.pmti.v1.itf.parser.*;

import java.io.*;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;

import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;


/**
 * Tests the XMLFileParser class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:05:47 $
 * @since     July 14, 2002
 */
public class XMLFileParserUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = XMLFileParserUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public XMLFileParserUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        try
        {
            new XMLFileParser( null, null );
        }
        catch (IllegalArgumentException e)
        {
            // test exception ???
        }
    }

    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected static File createSample1()
    {
        File f = new File( "test-" + System.currentTimeMillis() + ".xml" );
        PrintWriter pw = null;
        try
        {
            FileWriter fw = new FileWriter( f );
            pw = new PrintWriter( fw );
            
            pw.println( "<?xml version=\"1.0\"?>" );
            
            pw.println( "<testresult " );
            pw.println( "    suite=\"sample1\"" );
            pw.println( "    test=\"test1\"" );
            pw.println( "    tests=\"1\"" );
            pw.println( "    time=\"0.08\"" );
            pw.println( "    failures=\"0\"" );
            pw.println( "    errors=\"0\" >" );
            
            pw.println( "</testresult>" );
        }
        catch (IOException e)
        {
            e.printStackTrace();
            if (f.exists())
            {
                f.delete();
            }
            throw new IllegalStateException("unexpected exception: "+
                e.getMessage() );
        }
        finally
        {
            if (pw != null)
            {
                pw.close();
            }
        }
        return f;
    }
    
    
    protected static File createSample2()
    {
        File f = new File( "test-" + System.currentTimeMillis() + ".xml" );
        PrintWriter pw = null;
        try
        {
            FileWriter fw = new FileWriter( f );
            pw = new PrintWriter( fw );
            
            pw.println( "<?xml version=\"1.0\"?>" );
            
            pw.println( "<testresult>" );
            pw.println( "</testresult>" );
        }
        catch (IOException e)
        {
            e.printStackTrace();
            if (f.exists())
            {
                f.delete();
            }
            throw new IllegalStateException("unexpected exception: "+
                e.getMessage() );
        }
        finally
        {
            if (pw != null)
            {
                pw.close();
            }
        }
        return f;
    }
    
    
    protected static Parser createParser()
    {
        try
        {
            return SAXParserFactory.newInstance().newSAXParser().getParser();
        }
        catch (Exception e)
        {
            DOC.getLog().debug( "Creating SAX parser caused exception.", e );
            throw new IllegalStateException("Could not create a SAX parser: "+
                e.getMessage() );
        }
    }

    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IParserUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new XMLFileParser( createSample1(), createParser() );
            }
        } );
        suite.addFactory( new CxFactory( "B" ) {
            public Object createImplObject() {
                return new XMLFileParser( createSample2(), createParser() );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

