/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AccessFlags;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class MethodInfo
extends ClassMember {
    public static MethodInfo create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setClassFile(classFile);
        methodInfo.read(dataInput);
        return methodInfo;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "method with access flags " + this.printAccessFlags(this.accessFlags) + ", name_index " + this.nameIndex + ", descriptor_index " + this.descriptorIndex + ", " + this.getLength(this.attributes) + " attributes");
    }

    protected String printAccessFlagsVerbose(int n) {
        return this.printAccessFlagsVerbose(AccessFlags.METHOD_ACCESS_FLAGS, AccessFlags.METHOD_ACCESS_FLAGS_VERBOSE, n);
    }
}

