/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2010, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms,
with or without modification, are permitted provided that the
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** @file  BlenderScene.cpp
 *  @brief MACHINE GENERATED BY ./scripts/BlenderImporter/genblenddna.py
 */
#include "AssimpPCH.h"
#ifndef AI_BUILD_NO_BLEND_IMPORTER

#include "BlenderDNA.h"
#include "BlenderScene.h"
#include "BlenderSceneGen.h"

using namespace Assimp;
using namespace Assimp::Blender;

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Object> (
    Object& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Fail>((int&)dest.type,"type",db);
    ReadFieldArray2<ErrorPolicy_Warn>(dest.obmat,"obmat",db);
    ReadFieldArray2<ErrorPolicy_Warn>(dest.parentinv,"parentinv",db);
    ReadFieldArray<ErrorPolicy_Warn>(dest.parsubstr,"parsubstr",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.parent,"*parent",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.track,"*track",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.proxy,"*proxy",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.proxy_from,"*proxy_from",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.proxy_group,"*proxy_group",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.dup_group,"*dup_group",db);
    ReadFieldPtr<ErrorPolicy_Fail>(dest.data,"*data",db);
    ReadField<ErrorPolicy_Igno>(dest.modifiers,"modifiers",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Group> (
    Group& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Igno>(dest.layer,"layer",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.gobject,"*gobject",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MTex> (
    MTex& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Igno>((int&)dest.blendtype,"blendtype",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.object,"*object",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.tex,"*tex",db);
    ReadFieldArray<ErrorPolicy_Igno>(dest.uvname,"uvname",db);
    ReadField<ErrorPolicy_Igno>((int&)dest.projx,"projx",db);
    ReadField<ErrorPolicy_Igno>((int&)dest.projy,"projy",db);
    ReadField<ErrorPolicy_Igno>((int&)dest.projz,"projz",db);
    ReadField<ErrorPolicy_Igno>(dest.mapping,"mapping",db);
    ReadFieldArray<ErrorPolicy_Igno>(dest.ofs,"ofs",db);
    ReadFieldArray<ErrorPolicy_Igno>(dest.size,"size",db);
    ReadField<ErrorPolicy_Igno>(dest.rot,"rot",db);
    ReadField<ErrorPolicy_Igno>(dest.texflag,"texflag",db);
    ReadField<ErrorPolicy_Igno>(dest.colormodel,"colormodel",db);
    ReadField<ErrorPolicy_Igno>(dest.pmapto,"pmapto",db);
    ReadField<ErrorPolicy_Igno>(dest.pmaptoneg,"pmaptoneg",db);
    ReadField<ErrorPolicy_Warn>(dest.r,"r",db);
    ReadField<ErrorPolicy_Warn>(dest.g,"g",db);
    ReadField<ErrorPolicy_Warn>(dest.b,"b",db);
    ReadField<ErrorPolicy_Warn>(dest.k,"k",db);
    ReadField<ErrorPolicy_Igno>(dest.colspecfac,"colspecfac",db);
    ReadField<ErrorPolicy_Igno>(dest.mirrfac,"mirrfac",db);
    ReadField<ErrorPolicy_Igno>(dest.alphafac,"alphafac",db);
    ReadField<ErrorPolicy_Igno>(dest.difffac,"difffac",db);
    ReadField<ErrorPolicy_Igno>(dest.specfac,"specfac",db);
    ReadField<ErrorPolicy_Igno>(dest.emitfac,"emitfac",db);
    ReadField<ErrorPolicy_Igno>(dest.hardfac,"hardfac",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<TFace> (
    TFace& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldArray2<ErrorPolicy_Fail>(dest.uv,"uv",db);
    ReadFieldArray<ErrorPolicy_Fail>(dest.col,"col",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);
    ReadField<ErrorPolicy_Igno>(dest.mode,"mode",db);
    ReadField<ErrorPolicy_Igno>(dest.tile,"tile",db);
    ReadField<ErrorPolicy_Igno>(dest.unwrap,"unwrap",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<SubsurfModifierData> (
    SubsurfModifierData& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.modifier,"modifier",db);
    ReadField<ErrorPolicy_Igno>(dest.subdivType,"subdivType",db);
    ReadField<ErrorPolicy_Igno>(dest.levels,"levels",db);
    ReadField<ErrorPolicy_Igno>(dest.renderLevels,"renderLevels",db);
    ReadField<ErrorPolicy_Igno>(dest.flags,"flags",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MFace> (
    MFace& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.v1,"v1",db);
    ReadField<ErrorPolicy_Fail>(dest.v2,"v2",db);
    ReadField<ErrorPolicy_Fail>(dest.v3,"v3",db);
    ReadField<ErrorPolicy_Fail>(dest.v4,"v4",db);
    ReadField<ErrorPolicy_Fail>(dest.mat_nr,"mat_nr",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Lamp> (
    Lamp& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Fail>((int&)dest.type,"type",db);
    ReadField<ErrorPolicy_Igno>(dest.flags,"flags",db);
    ReadField<ErrorPolicy_Igno>(dest.colormodel,"colormodel",db);
    ReadField<ErrorPolicy_Igno>(dest.totex,"totex",db);
    ReadField<ErrorPolicy_Warn>(dest.r,"r",db);
    ReadField<ErrorPolicy_Warn>(dest.g,"g",db);
    ReadField<ErrorPolicy_Warn>(dest.b,"b",db);
    ReadField<ErrorPolicy_Warn>(dest.k,"k",db);
    ReadField<ErrorPolicy_Igno>(dest.energy,"energy",db);
    ReadField<ErrorPolicy_Igno>(dest.dist,"dist",db);
    ReadField<ErrorPolicy_Igno>(dest.spotsize,"spotsize",db);
    ReadField<ErrorPolicy_Igno>(dest.spotblend,"spotblend",db);
    ReadField<ErrorPolicy_Igno>(dest.att1,"att1",db);
    ReadField<ErrorPolicy_Igno>(dest.att2,"att2",db);
    ReadField<ErrorPolicy_Igno>((int&)dest.falloff_type,"falloff_type",db);
    ReadField<ErrorPolicy_Igno>(dest.sun_brightness,"sun_brightness",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MDeformWeight> (
    MDeformWeight& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.def_nr,"def_nr",db);
    ReadField<ErrorPolicy_Fail>(dest.weight,"weight",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<PackedFile> (
    PackedFile& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Warn>(dest.size,"size",db);
    ReadField<ErrorPolicy_Warn>(dest.seek,"seek",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.data,"*data",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Base> (
    Base& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldPtr<ErrorPolicy_Warn>(dest.prev,"*prev",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.next,"*next",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.object,"*object",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MTFace> (
    MTFace& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldArray2<ErrorPolicy_Fail>(dest.uv,"uv",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);
    ReadField<ErrorPolicy_Igno>(dest.mode,"mode",db);
    ReadField<ErrorPolicy_Igno>(dest.tile,"tile",db);
    ReadField<ErrorPolicy_Igno>(dest.unwrap,"unwrap",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Material> (
    Material& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Warn>(dest.r,"r",db);
    ReadField<ErrorPolicy_Warn>(dest.g,"g",db);
    ReadField<ErrorPolicy_Warn>(dest.b,"b",db);
    ReadField<ErrorPolicy_Warn>(dest.specr,"specr",db);
    ReadField<ErrorPolicy_Warn>(dest.specg,"specg",db);
    ReadField<ErrorPolicy_Warn>(dest.specb,"specb",db);
    ReadField<ErrorPolicy_Warn>(dest.ambir,"ambir",db);
    ReadField<ErrorPolicy_Warn>(dest.ambig,"ambig",db);
    ReadField<ErrorPolicy_Warn>(dest.ambib,"ambib",db);
    ReadField<ErrorPolicy_Igno>(dest.mirr,"mirr",db);
    ReadField<ErrorPolicy_Igno>(dest.mirg,"mirg",db);
    ReadField<ErrorPolicy_Igno>(dest.mirb,"mirb",db);
    ReadField<ErrorPolicy_Warn>(dest.emit,"emit",db);
    ReadField<ErrorPolicy_Warn>(dest.alpha,"alpha",db);
    ReadField<ErrorPolicy_Igno>(dest.ref,"ref",db);
    ReadField<ErrorPolicy_Igno>(dest.translucency,"translucency",db);
    ReadField<ErrorPolicy_Igno>(dest.roughness,"roughness",db);
    ReadField<ErrorPolicy_Igno>(dest.darkness,"darkness",db);
    ReadField<ErrorPolicy_Igno>(dest.refrac,"refrac",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.group,"*group",db);
    ReadField<ErrorPolicy_Warn>(dest.diff_shader,"diff_shader",db);
    ReadField<ErrorPolicy_Warn>(dest.spec_shader,"spec_shader",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.mtex,"*mtex",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Mesh> (
    Mesh& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Fail>(dest.totface,"totface",db);
    ReadField<ErrorPolicy_Fail>(dest.totedge,"totedge",db);
    ReadField<ErrorPolicy_Fail>(dest.totvert,"totvert",db);
    ReadField<ErrorPolicy_Igno>(dest.subdiv,"subdiv",db);
    ReadField<ErrorPolicy_Igno>(dest.subdivr,"subdivr",db);
    ReadField<ErrorPolicy_Igno>(dest.subsurftype,"subsurftype",db);
    ReadField<ErrorPolicy_Igno>(dest.smoothresh,"smoothresh",db);
    ReadFieldPtr<ErrorPolicy_Fail>(dest.mface,"*mface",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.mtface,"*mtface",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.tface,"*tface",db);
    ReadFieldPtr<ErrorPolicy_Fail>(dest.mvert,"*mvert",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.medge,"*medge",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.dvert,"*dvert",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.mcol,"*mcol",db);
    ReadFieldPtr<ErrorPolicy_Fail>(dest.mat,"**mat",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MDeformVert> (
    MDeformVert& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldPtr<ErrorPolicy_Warn>(dest.dw,"*dw",db);
    ReadField<ErrorPolicy_Igno>(dest.totweight,"totweight",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<World> (
    World& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MVert> (
    MVert& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldArray<ErrorPolicy_Fail>(dest.co,"co",db);
    ReadFieldArray<ErrorPolicy_Fail>(dest.no,"no",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);
    ReadField<ErrorPolicy_Warn>(dest.mat_nr,"mat_nr",db);
    ReadField<ErrorPolicy_Igno>(dest.bweight,"bweight",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MEdge> (
    MEdge& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.v1,"v1",db);
    ReadField<ErrorPolicy_Fail>(dest.v2,"v2",db);
    ReadField<ErrorPolicy_Igno>(dest.crease,"crease",db);
    ReadField<ErrorPolicy_Igno>(dest.bweight,"bweight",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<GroupObject> (
    GroupObject& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldPtr<ErrorPolicy_Fail>(dest.prev,"*prev",db);
    ReadFieldPtr<ErrorPolicy_Fail>(dest.next,"*next",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.ob,"*ob",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<ListBase> (
    ListBase& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldPtr<ErrorPolicy_Igno>(dest.first,"*first",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.last,"*last",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<ModifierData> (
    ModifierData& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldPtr<ErrorPolicy_Warn>(dest.next,"*next",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.prev,"*prev",db);
    ReadField<ErrorPolicy_Igno>(dest.type,"type",db);
    ReadField<ErrorPolicy_Igno>(dest.mode,"mode",db);
    ReadFieldArray<ErrorPolicy_Igno>(dest.name,"name",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<ID> (
    ID& dest,
    const FileDatabase& db
    ) const
{

    ReadFieldArray<ErrorPolicy_Warn>(dest.name,"name",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MCol> (
    MCol& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.r,"r",db);
    ReadField<ErrorPolicy_Fail>(dest.g,"g",db);
    ReadField<ErrorPolicy_Fail>(dest.b,"b",db);
    ReadField<ErrorPolicy_Fail>(dest.a,"a",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Image> (
    Image& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadFieldArray<ErrorPolicy_Warn>(dest.name,"name",db);
    ReadField<ErrorPolicy_Igno>(dest.ok,"ok",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);
    ReadField<ErrorPolicy_Igno>(dest.source,"source",db);
    ReadField<ErrorPolicy_Igno>(dest.type,"type",db);
    ReadField<ErrorPolicy_Igno>(dest.pad,"pad",db);
    ReadField<ErrorPolicy_Igno>(dest.pad1,"pad1",db);
    ReadField<ErrorPolicy_Igno>(dest.lastframe,"lastframe",db);
    ReadField<ErrorPolicy_Igno>(dest.tpageflag,"tpageflag",db);
    ReadField<ErrorPolicy_Igno>(dest.totbind,"totbind",db);
    ReadField<ErrorPolicy_Igno>(dest.xrep,"xrep",db);
    ReadField<ErrorPolicy_Igno>(dest.yrep,"yrep",db);
    ReadField<ErrorPolicy_Igno>(dest.twsta,"twsta",db);
    ReadField<ErrorPolicy_Igno>(dest.twend,"twend",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.packedfile,"*packedfile",db);
    ReadField<ErrorPolicy_Igno>(dest.lastupdate,"lastupdate",db);
    ReadField<ErrorPolicy_Igno>(dest.lastused,"lastused",db);
    ReadField<ErrorPolicy_Igno>(dest.animspeed,"animspeed",db);
    ReadField<ErrorPolicy_Igno>(dest.gen_x,"gen_x",db);
    ReadField<ErrorPolicy_Igno>(dest.gen_y,"gen_y",db);
    ReadField<ErrorPolicy_Igno>(dest.gen_type,"gen_type",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Scene> (
    Scene& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.camera,"*camera",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.world,"*world",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.basact,"*basact",db);
    ReadField<ErrorPolicy_Igno>(dest.base,"base",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Library> (
    Library& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadFieldArray<ErrorPolicy_Warn>(dest.name,"name",db);
    ReadFieldArray<ErrorPolicy_Fail>(dest.filename,"filename",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.parent,"*parent",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Tex> (
    Tex& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>((int&)dest.type,"type",db);
    ReadFieldPtr<ErrorPolicy_Warn>(dest.ima,"*ima",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<Camera> (
    Camera& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.id,"id",db);
    ReadField<ErrorPolicy_Warn>((int&)dest.type,"type",db);
    ReadField<ErrorPolicy_Warn>((int&)dest.flag,"flag",db);
    ReadField<ErrorPolicy_Warn>(dest.angle,"angle",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
template <> void Structure :: Convert<MirrorModifierData> (
    MirrorModifierData& dest,
    const FileDatabase& db
    ) const
{

    ReadField<ErrorPolicy_Fail>(dest.modifier,"modifier",db);
    ReadField<ErrorPolicy_Igno>(dest.axis,"axis",db);
    ReadField<ErrorPolicy_Igno>(dest.flag,"flag",db);
    ReadField<ErrorPolicy_Igno>(dest.tolerance,"tolerance",db);
    ReadFieldPtr<ErrorPolicy_Igno>(dest.mirror_ob,"*mirror_ob",db);

    db.reader->IncPtr(size);
}

//--------------------------------------------------------------------------------
void DNA::RegisterConverters() {

    converters["Object"]              = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Object>),              static_cast<ConvertProcPtr>(&Structure::Convert<Object>) );
    converters["Group"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Group>),               static_cast<ConvertProcPtr>(&Structure::Convert<Group>) );
    converters["MTex"]                = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MTex>),                static_cast<ConvertProcPtr>(&Structure::Convert<MTex>) );
    converters["TFace"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<TFace>),               static_cast<ConvertProcPtr>(&Structure::Convert<TFace>) );
    converters["SubsurfModifierData"] = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<SubsurfModifierData>), static_cast<ConvertProcPtr>(&Structure::Convert<SubsurfModifierData>) );
    converters["MFace"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MFace>),               static_cast<ConvertProcPtr>(&Structure::Convert<MFace>) );
    converters["Lamp"]                = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Lamp>),                static_cast<ConvertProcPtr>(&Structure::Convert<Lamp>) );
    converters["MDeformWeight"]       = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MDeformWeight>),       static_cast<ConvertProcPtr>(&Structure::Convert<MDeformWeight>) );
    converters["PackedFile"]          = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<PackedFile>),          static_cast<ConvertProcPtr>(&Structure::Convert<PackedFile>) );
    converters["Base"]                = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Base>),                static_cast<ConvertProcPtr>(&Structure::Convert<Base>) );
    converters["MTFace"]              = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MTFace>),              static_cast<ConvertProcPtr>(&Structure::Convert<MTFace>) );
    converters["Material"]            = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Material>),            static_cast<ConvertProcPtr>(&Structure::Convert<Material>) );
    converters["Mesh"]                = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Mesh>),                static_cast<ConvertProcPtr>(&Structure::Convert<Mesh>) );
    converters["MDeformVert"]         = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MDeformVert>),         static_cast<ConvertProcPtr>(&Structure::Convert<MDeformVert>) );
    converters["World"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<World>),               static_cast<ConvertProcPtr>(&Structure::Convert<World>) );
    converters["MVert"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MVert>),               static_cast<ConvertProcPtr>(&Structure::Convert<MVert>) );
    converters["MEdge"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MEdge>),               static_cast<ConvertProcPtr>(&Structure::Convert<MEdge>) );
    converters["GroupObject"]         = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<GroupObject>),         static_cast<ConvertProcPtr>(&Structure::Convert<GroupObject>) );
    converters["ListBase"]            = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<ListBase>),            static_cast<ConvertProcPtr>(&Structure::Convert<ListBase>) );
    converters["ModifierData"]        = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<ModifierData>),        static_cast<ConvertProcPtr>(&Structure::Convert<ModifierData>) );
    converters["ID"]                  = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<ID>),                  static_cast<ConvertProcPtr>(&Structure::Convert<ID>) );
    converters["MCol"]                = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MCol>),                static_cast<ConvertProcPtr>(&Structure::Convert<MCol>) );
    converters["Image"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Image>),               static_cast<ConvertProcPtr>(&Structure::Convert<Image>) );
    converters["Scene"]               = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Scene>),               static_cast<ConvertProcPtr>(&Structure::Convert<Scene>) );
    converters["Library"]             = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Library>),             static_cast<ConvertProcPtr>(&Structure::Convert<Library>) );
    converters["Tex"]                 = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Tex>),                 static_cast<ConvertProcPtr>(&Structure::Convert<Tex>) );
    converters["Camera"]              = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<Camera>),              static_cast<ConvertProcPtr>(&Structure::Convert<Camera>) );
    converters["MirrorModifierData"]  = DNA::FactoryPair( static_cast<AllocProcPtr>(&Structure::Allocate<MirrorModifierData>),  static_cast<ConvertProcPtr>(&Structure::Convert<MirrorModifierData>) );
}


#endif
