/*
 * unity-webapps-debug.h
 * Copyright (C) Canonical LTD 2012
 *
 * Author: Robert Carr <racarr@canonical.com>
 *
 * unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 *
 * Derived from seed-debug.h in turn derived from clutter-note.h.
 */

#ifndef _UNITY_WEBAPPS_DEBUG_H
#define _UNITY_WEBAPPS_DEBUG_H

// Borrowed from Seed, where this was borrowed from Clutter, more or less.

#include <glib.h>

typedef enum
{
  UNITY_WEBAPPS_DEBUG_ALL = 1 << 0,
  UNITY_WEBAPPS_DEBUG_CONTEXT = 1 << 1,
  UNITY_WEBAPPS_DEBUG_NOTIFICATION = 1 << 2,
  UNITY_WEBAPPS_DEBUG_INDICATOR = 1 << 3,
  UNITY_WEBAPPS_DEBUG_MUSIC_PLAYER = 1 << 4,
  UNITY_WEBAPPS_DEBUG_LAUNCHER = 1 << 5,
  UNITY_WEBAPPS_DEBUG_INTEREST = 1 << 6,
  UNITY_WEBAPPS_DEBUG_SERVICE = 1 << 7,
  UNITY_WEBAPPS_DEBUG_RESOURCE = 1 << 8,
  UNITY_WEBAPPS_DEBUG_RATE = 1 << 9,
  UNITY_WEBAPPS_DEBUG_ACTION = 1 << 10,
  UNITY_WEBAPPS_DEBUG_WINDOW_TRACKER = 1 << 11,
  UNITY_WEBAPPS_DEBUG_APPLICATION_INFO = 1 << 12,
  UNITY_WEBAPPS_DEBUG_INDICATOR_MODEL = 1 << 13,
  UNITY_WEBAPPS_DEBUG_URL_DB = 1 << 14,
  UNITY_WEBAPPS_DEBUG_APPLICATION_REPOSITORY = 1 << 15,
  UNITY_WEBAPPS_DEBUG_INDEX_UPDATER = 1 << 16,
  UNITY_WEBAPPS_DEBUG_MISC = 1 << 17,
  
} UnityWebappsDebugFlag;

static const GDebugKey unity_webapps_debug_keys[] = {
  {"notification", UNITY_WEBAPPS_DEBUG_NOTIFICATION},
  {"context", UNITY_WEBAPPS_DEBUG_CONTEXT},
  {"indicator", UNITY_WEBAPPS_DEBUG_INDICATOR},
  {"music-player", UNITY_WEBAPPS_DEBUG_MUSIC_PLAYER},
  {"launcher", UNITY_WEBAPPS_DEBUG_LAUNCHER},
  {"interest", UNITY_WEBAPPS_DEBUG_INTEREST},
  {"action", UNITY_WEBAPPS_DEBUG_ACTION},
  {"service", UNITY_WEBAPPS_DEBUG_SERVICE},
  {"resource", UNITY_WEBAPPS_DEBUG_RESOURCE},
  {"rate", UNITY_WEBAPPS_DEBUG_RATE},
  {"window-tracker", UNITY_WEBAPPS_DEBUG_WINDOW_TRACKER},
  {"application-info", UNITY_WEBAPPS_DEBUG_APPLICATION_INFO},
  {"url-db", UNITY_WEBAPPS_DEBUG_URL_DB},
  {"misc", UNITY_WEBAPPS_DEBUG_MISC},
  {"application-repository", UNITY_WEBAPPS_DEBUG_APPLICATION_REPOSITORY},
  {"index-updated", UNITY_WEBAPPS_DEBUG_INDEX_UPDATER}
};

#ifdef UNITY_WEBAPPS_ENABLE_DEBUG

#define UNITY_WEBAPPS_NOTE(type,...)  G_STMT_START {                 \
    if ((unity_webapps_debug_flags & UNITY_WEBAPPS_DEBUG_##type) ||           \
        unity_webapps_debug_flags & UNITY_WEBAPPS_DEBUG_ALL)                  \
    {                                                       \
        gchar * _fmt = g_strdup_printf (__VA_ARGS__);       \
        g_message ("[" #type "] " G_STRLOC ": %s",_fmt);    \
        g_free (_fmt);                                      \
    }                                                       \
} G_STMT_END

#define UNITY_WEBAPPS_MARK()      UNITY_WEBAPPS_NOTE(MISC, "== mark ==")
#define UNITY_WEBAPPS_DBG(x) { a }

#else /* !UNITY_WEBAPPS_ENABLE_DEBUG */

#define UNITY_WEBAPPS_NOTE(type,...)
#define UNITY_WEBAPPS_MARK()
#define UNITY_WEBAPPS_DBG(x)

#endif /* UNITY_WEBAPPS_ENABLE_DEBUG */

extern guint unity_webapps_debug_flags;

void unity_webapps_debug_initialize_flags ();

#endif
