# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.healthbot import HealthBotMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHealthBotMgmtBotsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HealthBotMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_get(self, resource_group):
        response = self.client.bots.get(
            resource_group_name=resource_group.name,
            bot_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_begin_create(self, resource_group):
        response = self.client.bots.begin_create(
            resource_group_name=resource_group.name,
            bot_name="str",
            parameters={
                "location": "str",
                "sku": {"name": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "accessControlMethod": "str",
                    "botManagementPortalLink": "str",
                    "keyVaultProperties": {
                        "keyName": "str",
                        "keyVaultUri": "str",
                        "keyVersion": "str",
                        "userIdentity": "str",
                    },
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_begin_update(self, resource_group):
        response = self.client.bots.begin_update(
            resource_group_name=resource_group.name,
            bot_name="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "properties": {
                    "accessControlMethod": "str",
                    "botManagementPortalLink": "str",
                    "keyVaultProperties": {
                        "keyName": "str",
                        "keyVaultUri": "str",
                        "keyVersion": "str",
                        "userIdentity": "str",
                    },
                    "provisioningState": "str",
                },
                "sku": {"name": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_begin_delete(self, resource_group):
        response = self.client.bots.begin_delete(
            resource_group_name=resource_group.name,
            bot_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_list_by_resource_group(self, resource_group):
        response = self.client.bots.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_list(self, resource_group):
        response = self.client.bots.list()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_list_secrets(self, resource_group):
        response = self.client.bots.list_secrets(
            resource_group_name=resource_group.name,
            bot_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bots_regenerate_api_jwt_secret(self, resource_group):
        response = self.client.bots.regenerate_api_jwt_secret(
            resource_group_name=resource_group.name,
            bot_name="str",
        )

        # please add some check logic here by yourself
        # ...
