# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import os
from typing import cast
from azure.ai.contentunderstanding.aio import ContentUnderstandingClient
from azure.core.credentials import AzureKeyCredential
from devtools_testutils import AzureRecordedTestCase, PowerShellPreparer
import functools


class ContentUnderstandingClientTestBaseAsync(AzureRecordedTestCase):

    def create_async_client(self, endpoint: str) -> ContentUnderstandingClient:
        # Normalize endpoint: remove trailing slashes to prevent double slashes in URLs
        endpoint = endpoint.rstrip("/")
        
        # Try API key first (for Content Understanding service)
        # Check CONTENTUNDERSTANDING_KEY
        key = os.getenv("CONTENTUNDERSTANDING_KEY")
        if key and key.strip():
            credential = AzureKeyCredential(key)
        else:
            # Fall back to service principal or AsyncDefaultAzureCredential
            credential = self.get_credential(ContentUnderstandingClient, is_async=True)
        return cast(
            ContentUnderstandingClient,
            self.create_client_from_credential(
                ContentUnderstandingClient,
                credential=credential,
                endpoint=endpoint,
                connection_verify=False,  # Disable SSL verification for localhost
                polling_interval=3,  # Use 3-second polling interval for test stability
            ),
        )


ContentUnderstandingPreparer = functools.partial(
    PowerShellPreparer,
    "contentunderstanding",
    contentunderstanding_endpoint="https://Sanitized.services.ai.azure.com",
)
