# Release History

## 6.0.0b1 (2026-01-19)

### Features Added

  - Model `AppConfigurationManagementClient` added parameter `cloud_setting` in method `__init__`
  - Client `AppConfigurationManagementClient` added method `send_request`
  - Model `ConfigurationStoreUpdateParameters` added property `properties`
  - Model `DeletedConfigurationStore` added property `system_data`
  - Model `KeyValue` added property `system_data`
  - Model `PrivateEndpointConnection` added property `system_data`
  - Model `PrivateEndpointConnectionReference` added property `properties`
  - Model `PrivateLinkResource` added property `system_data`
  - Model `Resource` added property `system_data`
  - Model `Snapshot` added property `system_data`
  - Model `TrackedResource` added property `system_data`
  - Added model `AzureFrontDoorProperties`
  - Added model `ConfigurationStorePropertiesUpdateParameters`
  - Added model `ManagedOnBehalfOfConfiguration`
  - Added model `MoboBrokerResource`
  - Added model `ProxyResource`
  - Added model `TelemetryProperties`

### Breaking Changes

  - This version introduces new hybrid models which have dual dictionary and model nature. Please follow https://aka.ms/azsdk/python/migrate/hybrid-models for migration.
  - For the method breakings, please refer to https://aka.ms/azsdk/python/migrate/operations for migration.
  - Model `ConfigurationStoreUpdateParameters` moved instance variable `encryption`, `disable_local_auth`, `public_network_access`, `enable_purge_protection`, `data_plane_proxy` and `default_key_value_revision_retention_period_in_seconds` under property `properties`
  - Model `PrivateEndpointConnectionReference` moved instance variable `provisioning_state`, `private_endpoint` and `private_link_service_connection_state` under property `properties`
  - Method `ConfigurationStoresOperations.list` changed its parameter `skip_token` from `positional_or_keyword` to `keyword_only`
  - Method `ConfigurationStoresOperations.list_by_resource_group` changed its parameter `skip_token` from `positional_or_keyword` to `keyword_only`
  - Method `ConfigurationStoresOperations.list_keys` changed its parameter `skip_token` from `positional_or_keyword` to `keyword_only`
  - Method `Operations.list` changed its parameter `skip_token` from `positional_or_keyword` to `keyword_only`
  - Method `ReplicasOperations.list_by_configuration_store` changed its parameter `skip_token` from `positional_or_keyword` to `keyword_only`

### Other Changes

  - Deleted model `ErrorDetails`/`ErrorResponseAutoGenerated` which actually were not used by SDK users

## 5.0.0 (2025-06-17)

### Features Added

  - Model `ConfigurationStore` added property `default_key_value_revision_retention_period_in_seconds`
  - Model `ConfigurationStoreUpdateParameters` added property `default_key_value_revision_retention_period_in_seconds`

### Breaking Changes
  - Parameter `key_value_parameters` of method `KeyValuesOperations.create_or_update` is now required

## 4.0.0 (2024-10-29)

### Breaking Changes

  - This package now only targets the latest Api-Version available on Azure and removes APIs of other Api-Version. After this change, the package can have much smaller size. If your application requires a specific and non-latest Api-Version, it's recommended to pin this package to the previous released version; If your application always only use latest Api-Version, please ignore this change.

## 3.1.0 (2024-10-21)

### Features Added

  - Added operation group SnapshotsOperations
  - Model ConfigurationStore has a new parameter data_plane_proxy
  - Model ConfigurationStoreUpdateParameters has a new parameter data_plane_proxy

## 3.0.0 (2023-03-27)

### Breaking Changes

  - Removed operation KeyValuesOperations.list_by_configuration_store

## 3.0.0b1 (2023-02-15)

### Breaking Changes

  - Removed operation KeyValuesOperations.list_by_configuration_store

## 2.2.0 (2022-08-29)

### Features Added

  - Added operation group ReplicasOperations

### Other Changes

  - Changed to multiapi package(please refer to https://github.com/Azure/azure-sdk-for-python/blob/20a21f4bee6164eea84eab83eddd272d76ff9839/doc/dev/mgmt/multiapi.md for more info)

## 2.1.0 (2022-06-08)

**Features**

  - Added operation ConfigurationStoresOperations.begin_purge_deleted
  - Added operation ConfigurationStoresOperations.get_deleted
  - Added operation ConfigurationStoresOperations.list_deleted
  - Added operation Operations.regional_check_name_availability
  - Model ConfigurationStore has a new parameter create_mode
  - Model ConfigurationStore has a new parameter enable_purge_protection
  - Model ConfigurationStore has a new parameter soft_delete_retention_in_days
  - Model ConfigurationStoreUpdateParameters has a new parameter enable_purge_protection

## 2.1.0b2 (2022-02-28)

**Features**

  - Model ConfigurationStoreUpdateParameters has a new parameter enable_purge_protection

## 2.1.0b1 (2022-02-16)

**Features**

  - Added operation ConfigurationStoresOperations.begin_purge_deleted
  - Added operation ConfigurationStoresOperations.get_deleted
  - Added operation ConfigurationStoresOperations.list_deleted
  - Added operation Operations.regional_check_name_availability
  - Model ConfigurationStore has a new parameter create_mode
  - Model ConfigurationStore has a new parameter enable_purge_protection
  - Model ConfigurationStore has a new parameter soft_delete_retention_in_days

## 2.0.0 (2021-06-21)

**Features**

  - Model OperationDefinition has a new parameter properties
  - Model OperationDefinition has a new parameter is_data_action
  - Model OperationDefinition has a new parameter origin
  - Model KeyValue has a new parameter id
  - Model KeyValue has a new parameter type
  - Model KeyValue has a new parameter name
  - Model ConfigurationStore has a new parameter system_data
  - Model ConfigurationStore has a new parameter disable_local_auth
  - Model ConfigurationStoreUpdateParameters has a new parameter disable_local_auth
  - Added operation group KeyValuesOperations

**Breaking changes**

  - Model Resource no longer has parameter location
  - Model Resource no longer has parameter tags
  - Removed operation ConfigurationStoresOperations.list_key_value

## 1.0.1 (2020-09-18)

**Bug fix**

  - Require azure-mgmt-core>=1.2.0 in setup.py

## 1.0.0 (2020-09-15)

**Features**

  - Model ConfigurationStoreUpdateParameters has a new parameter public_network_access

## 1.0.0b1 (2020-06-17)

This is beta preview version.

This version uses a next-generation code generator that introduces important breaking changes, but also important new features (like unified authentication and async programming).

**General breaking changes**

- Credential system has been completly revamped:

  - `azure.common.credentials` or `msrestazure.azure_active_directory` instances are no longer supported, use the `azure-identity` classes instead: https://pypi.org/project/azure-identity/
  - `credentials` parameter has been renamed `credential`

- The `config` attribute no longer exists on a client, configuration should be passed as kwarg. Example: `MyClient(credential, subscription_id, enable_logging=True)`. For a complete set of
  supported options, see the [parameters accept in init documentation of azure-core](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/CLIENT_LIBRARY_DEVELOPER.md#available-policies)
- You can't import a `version` module anymore, use `__version__` instead
- Operations that used to return a `msrest.polling.LROPoller` now returns a `azure.core.polling.LROPoller` and are prefixed with `begin_`.
- Exceptions tree have been simplified and most exceptions are now `azure.core.exceptions.HttpResponseError` (`CloudError` has been removed).
- Most of the operation kwarg have changed. Some of the most noticeable:

  - `raw` has been removed. Equivalent feature can be found using `cls`, a callback that will give access to internal HTTP response for advanced user
  - For a complete set of
  supported options, see the [parameters accept in Request documentation of azure-core](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/core/azure-core/CLIENT_LIBRARY_DEVELOPER.md#available-policies)

**General new features**

- Type annotations support using `typing`. SDKs are mypy ready.
- This client has now stable and official support for async. Check the `aio` namespace of your package to find the async client.
- This client now support natively tracing library like OpenCensus or OpenTelemetry. See this [tracing quickstart](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/core/azure-core-tracing-opentelemetry) for an overview.

## 0.4.0 (2020-02-07)

**Features**

- Model ConfigurationStoreUpdateParameters has a new parameter encryption
- Model ConfigurationStore has a new parameter encryption
- Added operation group PrivateEndpointConnectionsOperations
- Added operation group PrivateLinkResourcesOperations

**Breaking changes**

- Model ConfigurationStoreUpdateParameters no longer has parameter properties

## 0.3.0 (2019-11-08)

**Features**

  - Model ConfigurationStore has a new parameter identity
  - Model ConfigurationStoreUpdateParameters has a new parameter
    identity
  - Model ConfigurationStoreUpdateParameters has a new parameter sku

**Breaking changes**

  - Operation ConfigurationStoresOperations.create has a new signature
  - Operation ConfigurationStoresOperations.update has a new signature
  - Model ConfigurationStore has a new required parameter sku

## 0.2.0 (2019-11-04)

**Features**

  - Added operation ConfigurationStoresOperations.list_key_value

## 0.1.0 (2019-06-17)

  - Initial Release
