export const samples = {
  // https://www.npmjs.com/package/ansi-regex
  "ansi-regex":
    "/[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?(?:\\u0007|\\u001B\\u005C|\\u009C))|(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-nq-uy=><~]))/",
  // https://www.npmjs.com/package/astral-regex
  "astral-regex": "/[\uD800-\uDBFF][\uDC00-\uDFFF]/",
  // https://www.npmjs.com/package/doi-regex
  "doi-regex": '/(10[.][0-9]{2,}(?:[.][0-9]+)*/(?:(?![%"#? ])\\S)+)/',
  // https://www.npmjs.com/package/email-regex
  "email-regex":
    "/[^\\.\\s@:](?:[^\\s@:]*[^\\s@:\\.])?@[^\\.\\s@]+(?:\\.[^\\.\\s@]+)*/",
  // https://www.npmjs.com/package/emoji-regex
  "emoji-regex":
    "/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uD83C[\\uDFFB-\\uDFFF]|\\uFE0F)?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26D3\\uFE0F?(?:\\u200D\\uD83D\\uDCA5)?|\\u26F9(?:\\uD83C[\\uDFFB-\\uDFFF]|\\uFE0F)?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uD83C[\\uDFFB-\\uDFFF]|\\uFE0F)?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF43\\uDF45-\\uDF4A\\uDF4C-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDF44(?:\\u200D\\uD83D\\uDFEB)?|\\uDF4B(?:\\u200D\\uD83D\\uDFE9)?|\\uDFC3(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4\\uDEB5](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uD83C[\\uDFFB-\\uDFFF]|\\uFE0F)?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE41\\uDE43\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC08(?:\\u200D\\u2B1B)?|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC26(?:\\u200D(?:\\u2B1B|\\uD83D\\uDD25))?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uD83C[\\uDFFB-\\uDFFF]|\\uFE0F)?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?|\\uDE42(?:\\u200D[\\u2194\\u2195]\\uFE0F?)?|\\uDEB6(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE89\\uDE8F-\\uDEC2\\uDEC6\\uDECE-\\uDEDC\\uDEDF-\\uDEE9]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDCE(?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D(?:[\\u2640\\u2642]\\uFE0F?(?:\\u200D\\u27A1\\uFE0F?)?|\\u27A1\\uFE0F?))?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1|\\uDDD1\\u200D\\uD83E\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?|\\uDDD2(?:\\u200D\\uD83E\\uDDD2)?))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF\\uDDBC\\uDDBD](?:\\u200D\\u27A1\\uFE0F?)?|[\\uDDB0-\\uDDB3]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g",
  // https://www.npmjs.com/package/ip-regex
  "ip-regex":
    "/(?:^(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}$)|(?:^(?:(?:[a-fA-F\\d]{1,4}:){7}(?:[a-fA-F\\d]{1,4}|:)|(?:[a-fA-F\\d]{1,4}:){6}(?:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|:[a-fA-F\\d]{1,4}|:)|(?:[a-fA-F\\d]{1,4}:){5}(?::(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,2}|:)|(?:[a-fA-F\\d]{1,4}:){4}(?:(?::[a-fA-F\\d]{1,4}){0,1}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,3}|:)|(?:[a-fA-F\\d]{1,4}:){3}(?:(?::[a-fA-F\\d]{1,4}){0,2}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,4}|:)|(?:[a-fA-F\\d]{1,4}:){2}(?:(?::[a-fA-F\\d]{1,4}){0,3}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,5}|:)|(?:[a-fA-F\\d]{1,4}:){1}(?:(?::[a-fA-F\\d]{1,4}){0,4}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,6}|:)|(?::(?:(?::[a-fA-F\\d]{1,4}){0,5}:(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(?::[a-fA-F\\d]{1,4}){1,7}|:)))(?:%[0-9a-zA-Z]{1,})?$)/",
  // https://www.npmjs.com/package/identifier-regex
  "identifier-regex": "/[$_\\p{ID_Start}][$_\\u200C\\u200D\\p{ID_Continue}]*/u",
  // https://www.npmjs.com/package/issue-regex
  "issue-regex":
    "/(?<!\\w)(?:(?:(?<organization>[a-z\\d](?:[a-z\\d-]{0,37}[a-z\\d])?)(?:\\/(?<repository>[\\w.-]{1,100}))?)?(?<!\\/\\.{1,2})#)(?<issueNumber>[1-9]\\d{0,9})\\b/",
  // https://www.npmjs.com/package/mapcode-regex
  "mapcode-regex":
    "/(?:(11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65|71|91|92|AAA|AB|ABW|AC|ACT|AD|AFG|AG|AGO|AGU|AH|AIA|AK|AL|ALA|ALB|ALT|AM|AMU|AN|AND|AP|AR|ARE|ARG|ARK|ARM|AS|ASC|ASM|AST|ATA|ATF|ATG|AU|AU-ACT|AU-CC|AU-CX|AU-HM|AU-JBT|AU-NF|AU-NSW|AU-NT|AU-QLD|AU-SA|AU-TAS|AU-VIC|AU-WA|AUS|AUT|AZ|AZE|Aaland Islands|Acre|Adygea Republic|Afghanistan, Islamic Republic of|Aguascalientes|Alabama|Alagoas|Alaska|Albania, Republic of|Alberta|Algeria, People's Democratic Republic of|Altai Krai|Altai Republic|Amapa|Amazonas|American Samoa|Amur Oblast|Andaman and Nicobar|Andhra Pradesh|Andorra, Principality of|Angola, Republic of|Anguilla|Anhui Province|Antarctica|Antigua and Barbuda|Argentina|Arizona|Arkansas|Arkhangelsk Oblast|Armenia, Republic of|Aruba|Arunachal Pradesh|Assam|Astrakhan Oblast|Australia, Commonwealth of|Australian Capital Territory|Austria, Republic of|Azerbaijan, Republic of|BA|BC|BCN|BCS|BDI|BE|BEL|BEN|BES|BFA|BGD|BGR|BHR|BHS|BIH|BJ|BLM|BLR|BLZ|BMU|BOL|BR|BR-AC|BR-AL|BR-AM|BR-AP|BR-BA|BR-CE|BR-DF|BR-ES|BR-GO|BR-MA|BR-MG|BR-MS|BR-MT|BR-PA|BR-PB|BR-PE|BR-PI|BR-PR|BR-RJ|BR-RN|BR-RO|BR-RR|BR-RS|BR-SC|BR-SE|BR-SP|BR-TO|BRA|BRB|BRN|BRY|BS|BTN|BU|BVT|BWA|Bahamas, Commonwealth of the|Bahia|Bahrain, Kingdom of|Baja California|Baja California Sur|Bangladesh, People's Republic of|Barbados|Bashkortostan Republic|Beijing Municipality|Belarus, Republic of|Belgium, Kingdom of|Belgorod Oblast|Belize|Benin, Republic of|Bermuda|Bhutan, Kingdom of|Bihar|Bolivia, Plurinational State of|Bonaire, St Eustasuis and Saba|Bosnia and Herzegovina|Botswana, Republic of|Bouvet Island|Brazil, Federative Republic of|British Columbia|British Indian Ocean Territory|British Virgin Islands|Brunei, Nation of|Bryansk Oblast|Bulgaria, Republic of|Burkina Faso|Burundi, Republic of|Buryatia Republic|CA|CA-AB|CA-BC|CA-MB|CA-NB|CA-NL|CA-NS|CA-NT|CA-NU|CA-ON|CA-PE|CA-QC|CA-SK|CA-YT|CAF|CAM|CAN|CC|CCK|CE|CG|CH|CHE|CHH|CHL|CHN|CHP|CHU|CIV|CL|CM|CMR|CN|CN-11|CN-12|CN-13|CN-14|CN-15|CN-21|CN-22|CN-23|CN-31|CN-32|CN-33|CN-34|CN-35|CN-36|CN-37|CN-41|CN-42|CN-43|CN-44|CN-45|CN-46|CN-50|CN-51|CN-52|CN-53|CN-54|CN-61|CN-62|CN-63|CN-64|CN-65|CN-71|CN-91|CN-92|CN-AH|CN-BJ|CN-CQ|CN-FJ|CN-GD|CN-GS|CN-GX|CN-GZ|CN-HA|CN-HB|CN-HE|CN-HI|CN-HK|CN-HL|CN-HN|CN-JL|CN-JS|CN-JX|CN-LN|CN-MC|CN-NM|CN-NX|CN-QH|CN-SC|CN-SD|CN-SH|CN-SN|CN-SX|CN-TJ|CN-TW|CN-XJ|CN-XZ|CN-YN|CN-ZJ|CO|COA|COD|COG|COK|COL|COM|CPT|CPV|CQ|CRI|CS|CT|CU|CUB|CUW|CX|CXR|CYM|CYP|CZE|California|Cambodia, Kingdom of|Cameroon, Republic of|Campeche|Canada|Cape Verde|Cayman islands|Ceara|Central African Republic|Chad, Republic of|Chandigarh|Chechen Republic|Chelyabinsk Oblast|Chhattisgarh|Chiapas|Chihuahua|Chile, Republic of|China, People's Republic of|Chongqing Municipality|Christmas Island|Chukotka Okrug|Chuvash Republic|Clipperton Island|Coahuila|Cocos Islands|Colima|Colombia, Republic of|Colorado|Comoros, Union of the|Congo-Brazzaville|Congo-Kinshasa|Connecticut|Cook Islands|Costa Rica, Republic of|Croatia, Republic of|Cuba, Republic of|Curacao|Cyprus, Republic of|Czech Republic|DA|DC|DD|DE|DEU|DF|DG|DGA|DIF|DJI|DL|DMA|DN|DNK|DOM|DUR|DZA|Dadra and Nagar Haveli|Dagestan Republic|Daman and Diu|Delaware|Delhi, National Capital Territory of|Denmark, Kingdom of|District of Columbia|Distrito Federal|Djibouti, Republic of|Dominica, Commonwealth of|Dominican Republic|Durango|ECU|EGY|ERI|ES|ESH|ESP|EST|ETH|Ecuador, Republic of|Egypt, Arab Republic of|El Salvador, Republic of|Equatorial Guinea, Republic of|Eritrea, State of|Espirito Santo|Estonia, Republic of|Ethiopia, Federal Democratic Republic of|FIN|FJ|FJI|FL|FLK|FRA|FRO|FSM|Falkland Islands|Faroe Islands|Federal District|Fiji, Republic of|Finland, Republic of|Florida|France|French Guiana|French Polynesia, Collectivity of|French Southern and Antarctic Lands|Fujian Province|GA|GAB|GBR|GD|GEO|GGY|GHA|GIB|GIN|GJ|GLP|GMB|GNB|GNQ|GO|GR|GRC|GRD|GRL|GRO|GS|GT|GTM|GU|GUA|GUF|GUM|GUY|GX|GZ|Gabon|Gambia, Republic of the|Gansu Province|Georgia|Germany, Federal Republic of|Ghana, Republic of|Gibraltar|Goa|Goias|Greece|Greenland|Grenada|Guadeloupe|Guam|Guanajuato|Guangdong Province|Guangxi Zhuang Autonomous Region|Guatemala, Republic of|Guernsey, Bailiwick of|Guerrero|Guinea, Republic of|Guinea-Bissau, Republic of|Guizhou Province|Gujarat|Guyana, Co-operative Republic of|HA|HB|HE|HG|HI|HID|HK|HKG|HL|HM|HMD|HN|HND|HP|HR|HRV|HTI|HUN|Hainan Province|Haiti, Republic of|Haryana|Hawaii|Heard Island and McDonald Islands|Hebei Province|Heilongjiang Province|Henan Province|Hidalgo|Himachal Pradesh|Honduras, Republic of|Hong Kong|Hubei Province|Hunan Province|Hungary, Republic of|IA|ID|IDN|IL|IMN|IN|IN-AN|IN-AP|IN-AR|IN-AS|IN-BR|IN-CG|IN-CH|IN-CT|IN-DD|IN-DL|IN-DN|IN-GA|IN-GJ|IN-HP|IN-HR|IN-JH|IN-JK|IN-KA|IN-KL|IN-LD|IN-MH|IN-ML|IN-MN|IN-MP|IN-MZ|IN-NL|IN-OD|IN-OR|IN-PB|IN-PY|IN-RJ|IN-SK|IN-TG|IN-TN|IN-TR|IN-UK|IN-UP|IN-UT|IN-WB|IND|IOT|IRK|IRL|IRN|IRQ|ISL|ISR|ITA|IVA|Iceland|Idaho|Illinois|India, Republic of|Indiana|Indonesia, Republic of|Ingushetia|International|Iowa|Iran, Islamic Republic of|Iraq, Republic of|Ireland, Republic of|Irkutsk Oblast|Isle of Mann|Israel, State of|Italy|Ivanovo Oblast|Ivory Coast|JA|JAL|JAM|JBT|JEY|JH|JK|JL|JOR|JPN|JS|JTN|JX|Jalisco|Jamaica|Jammu and Kashmir|Japan|Jersey, Bailiwick of|Jervis Bay Territory|Jewish Autonomous Oblast|Jharkhand|Jiangsu Province|Jiangxi Province|Jilin Province|Jordan, Hashemite Kingdom of|KA|KAM|KAZ|KB|KC|KDA|KEM|KEN|KGD|KGN|KGZ|KHA|KHM|KI|KIR|KK|KL|KLU|KM|KNA|KO|KOR|KOS|KR|KRS|KS|KWT|KY|KYA|Kabardino-Balkar Republic|Kaliningrad Oblast|Kalmykia Republic|Kaluga Oblast|Kamchatka Krai|Kansas|Karachay-Cherkess Republic|Karelia Republic|Karnataka|Kazakhstan, Republic of|Kemerovo Oblast|Kentucky, Commonwealth of|Kenya, Republic of|Kerala|Khabarovsk Krai|Khakassia Republic|Khanty-Mansi|Kiribati, Republic of|Kirov Oblast|Komi Republic|Kostroma Oblast|Krasnodar Krai|Krasnoyarsk Krai|Kurgan Oblast|Kursk Oblast|Kuwait, State of|Kyrgyzstan|LA|LAO|LBN|LBR|LBY|LCA|LD|LEN|LIE|LIP|LKA|LN|LSO|LTU|LUX|LVA|Lakshadweep|Laos|Latvia, Republic of|Lebanon|Leningrad Oblast|Lesotho, Kingdom of|Liaoning Province|Liberia, Republic of|Libya|Liechtenstein, Principality of|Lipetsk Oblast|Lithuania, Republic of|Louisiana|Luxembourg, Grand Duchy of|MA|MAC|MAF|MAG|MAR|MB|MC|MCO|MD|MDA|MDG|MDV|ME|MEX|MG|MH|MHL|MI|MIC|MID|MKD|ML|MLI|MLT|MMR|MN|MNE|MNG|MNP|MO|MOR|MOS|MOW|MOZ|MP|MRT|MS|MSR|MT|MTQ|MUR|MUS|MWI|MX|MX-AG|MX-AGU|MX-BC|MX-BCN|MX-BCS|MX-BS|MX-CAM|MX-CH|MX-CHH|MX-CHP|MX-CL|MX-CM|MX-CO|MX-COA|MX-COL|MX-CS|MX-DF|MX-DG|MX-DIF|MX-DUR|MX-GR|MX-GRO|MX-GT|MX-GUA|MX-HG|MX-HID|MX-JA|MX-JAL|MX-ME|MX-MEX|MX-MI|MX-MIC|MX-MO|MX-MOR|MX-MX|MX-NA|MX-NAY|MX-NL|MX-NLE|MX-OA|MX-OAX|MX-PB|MX-PUE|MX-QE|MX-QR|MX-QUE|MX-ROO|MX-SI|MX-SIN|MX-SL|MX-SLP|MX-SO|MX-SON|MX-TAB|MX-TAM|MX-TB|MX-TL|MX-TLA|MX-TM|MX-VE|MX-VER|MX-YU|MX-YUC|MX-ZA|MX-ZAC|MYS|MYT|MZ|Macau|Macedonia, Republic of|Madagascar, Republic of|Madhya Pradesh|Magadan Oblast|Maharashtra|Maine|Malawi, Republic of|Malaysia|Maldives, Republic of|Mali, Republic of|Malta, Republic of|Manipur|Manitoba|Maranhao|Mari El Republic|Marshall Islands, Republic of the|Martinique|Maryland|Massachusetts, Commonwealth of|Mato Grosso|Mato Grosso do Sul|Mauritania, Islamic Republic of|Mauritius, Republic of|Mayotte|Meghalaya|Mexico|Mexico State|Michigan|Michoacan|Micronesia|Minas Gerais|Minnesota|Mississippi|Missouri|Mizoram|Moldova, Republic of|Monaco, Principality of|Mongolia|Montana|Montenegro|Montserrat|Mordovia Republic|Morelos|Morocco, Kingdom of|Moscow|Moscow Oblast|Mozambique, Republic of|Murmansk Oblast|Myanmar, Republic of the Union of|NA|NAM|NAY|NB|NC|NCL|ND|NE|NEN|NER|NF|NFK|NGA|NGR|NH|NIC|NIU|NIZ|NJ|NL|NLD|NLE|NM|NOR|NPL|NRU|NS|NSW|NT|NU|NV|NVS|NX|NY|NZL|Nagaland|Namibia, Republic of|Nauru, Republic of|Nayarit|Nebraska|Nei Mongol Autonomous Region|Nenets Autonomous Okrug|Nepal, Federal Democratic Republic of|Netherlands, Kingdom of the|Nevada|New Brunswick|New Caledonia|New Hampshire|New Jersey|New Mexico|New South Wales|New York|New Zealand|Newfoundland and Labrador|Nicaragua, Republic of|Niger, Republic of|Nigeria, Federal Republic of|Ningxia Hui Autonomous Region|Niue|Nizhny Novgorod Oblast|Norfolk and Philip Island|North Carolina|North Dakota|North Korea|North Ossetia-Alania Republic|Northern Mariana Islands, Commonwealth of the|Northern Territory|Northwest Territories|Norway, Kingdom of|Nova Scotia|Novgorod Oblast|Novosibirsk Oblast|Nuevo Leon|Nunavut|OA|OAX|OD|OH|OK|OMN|OMS|ON|OR|ORE|ORL|Oaxaca|Odisha|Ohio|Oklahoma|Oman, Sultanate of|Omsk Oblast|Ontario|Oregon|Orenburg Oblast|Oryol Oblast|PA|PAK|PAN|PB|PCN|PE|PER|PHL|PI|PLW|PM|PNG|PNZ|PO|POL|PR|PRI|PRK|PRT|PRY|PSE|PSK|PUE|PY|PYF|Pakistan, Islamic Republic of|Palau, Republic of|Palestinian territories|Panama, Republic of|Papua New Guinea, Independent State of|Para|Paraguay, Republic of|Paraiba|Parana|Pennsylvania, Commonwealth of|Penza Oblast|Perm Krai|Pernambuco|Peru, Republic of|Philippines, Republic of the|Piaui|Pitcairn Islands|Poland, Republic of|Portugal|Primorsky Krai|Prince Edward Island|Pskov Oblast|Puducherry|Puebla|Puerto Rico, Commonwealth of|Punjab|QAT|QC|QE|QH|QLD|QR|QUE|Qatar, State of|Qinghai Province|Quebec|Queensland|Queretaro|Quintana Roo|REU|RI|RJ|RN|RO|ROO|ROS|ROU|RR|RS|RU|RU-AD|RU-AL|RU-ALT|RU-AMU|RU-ARK|RU-AST|RU-BA|RU-BE|RU-BEL|RU-BRY|RU-BU|RU-CE|RU-CH|RU-CHE|RU-CHU|RU-CU|RU-DA|RU-IN|RU-IRK|RU-IVA|RU-KAM|RU-KB|RU-KC|RU-KDA|RU-KEM|RU-KGD|RU-KGN|RU-KHA|RU-KHM|RU-KI|RU-KIR|RU-KK|RU-KL|RU-KLU|RU-KM|RU-KO|RU-KOS|RU-KR|RU-KRS|RU-KYA|RU-LEN|RU-LIP|RU-MAG|RU-ME|RU-MO|RU-MOS|RU-MOW|RU-MUR|RU-NEN|RU-NGR|RU-NIZ|RU-NVS|RU-OMS|RU-ORE|RU-ORL|RU-PER|RU-PM|RU-PNZ|RU-PO|RU-PRI|RU-PSK|RU-ROS|RU-RYA|RU-SA|RU-SAK|RU-SAM|RU-SAR|RU-SE|RU-SMO|RU-SPE|RU-STA|RU-SVE|RU-TA|RU-TAM|RU-TOM|RU-TT|RU-TUL|RU-TVE|RU-TY|RU-TYU|RU-UD|RU-ULY|RU-VGG|RU-VLA|RU-VLG|RU-VOR|RU-YAN|RU-YAR|RU-YEV|RU-ZAB|RUS|RWA|RYA|Rajasthan|Reunion|Rhode Island|Rio Grande do Norte|Rio Grande do Sul|Rio de Janeiro|Romania|Rondonia|Roraima|Rostov Oblast|Russia|Rwanda, Republic of|Ryazan Oblast|SA|SAK|SAM|SAR|SAU|SC|SD|SDN|SE|SEN|SGP|SGS|SH|SHN|SI|SIN|SJM|SK|SL|SLB|SLE|SLP|SLV|SMO|SMR|SN|SO|SOM|SON|SP|SPE|SPM|SRB|SSD|STA|STP|SUR|SVE|SVK|SVN|SWE|SWZ|SX|SXM|SYC|SYR|Saint Helena, Ascension and Tristan da Cunha|Saint Kitts and Nevis, Federation of|Saint Lucia|Saint Martin, Collectivity of|Saint Petersburg|Saint Pierre and Miquelon, Collectivity of|Saint Vincent and the Grenadines|Saint-Barthelemy, Collectivity of|Sakha Republic|Sakhalin Oblast|Samara Oblast|Samoa, Independent State of|San Luis Potosi|San Marino, Republic of|Santa Catarina|Sao Paulo|Sao Tome and Principe, Democratic Republic of|Saratov Oblast|Saskatchewan|Saudi Arabia, Kingdom of|Senegal, Republic of|Serbia, Republic of|Sergipe|Seychelles, Republic of|Shaanxi Province|Shandong Province|Shanghai Municipality|Shanxi Province|Sichuan Province|Sierra Leone, Republic of|Sikkim|Sinaloa|Singapore, Republic of|Sint Maarten|Slovakia|Slovenia, Republic of|Smolensk Oblast|Solomon Islands|Somalia, Federal Republic of|Sonora|South Africa, Republic of|South Australia|South Carolina|South Dakota|South Georgia and the South Sandwich Islands|South Korea|South Sudan, Republic of|Spain, Kingdom of|Sri Lanka, Democratic Socialist Republic of|Stavropol Krai|Sudan, Republic of the|Suriname, Republic of|Svalbard and Jan Mayen|Sverdlovsk Oblast|Swaziland, Kingdom of|Sweden, Kingdom of|Switzerland|Syria|TA|TAA|TAB|TAM|TAS|TB|TCA|TCD|TG|TGO|THA|TJ|TJK|TKL|TKM|TL|TLA|TLS|TM|TN|TO|TOM|TON|TR|TT|TTO|TUL|TUN|TUR|TUV|TVE|TW|TWN|TX|TY|TYU|TZA|Tabasco|Taiwan|Tajikistan, Republic of|Tamaulipas|Tambov Oblast|Tamil Nadu|Tanzania, United Republic of|Tasmania|Tatarstan Republic|Telangana|Tennessee|Texas|Thailand, Kingdom of|Tianjin Municipality|Timor-Leste, Democratic Republic of|Tlaxcala|Tocantins|Togo|Tokelau|Tomsk Oblast|Tonga, Kingdom of|Trinidad and Tobago, Republic of|Tripura|Tula Oblast|Tunisia, Republic of|Turkey, Republic of|Turkmenistan|Turks and Caicos Islands|Tuva Republic|Tuvalu|Tver Oblast|Tyumen Oblast|UD|UGA|UK|UKR|ULY|UM|UMI|UP|URY|US|US-AK|US-AL|US-AR|US-AS|US-AZ|US-CA|US-CO|US-CT|US-DC|US-DE|US-FL|US-GA|US-GU|US-HI|US-IA|US-ID|US-IL|US-IN|US-KS|US-KY|US-LA|US-MA|US-MD|US-ME|US-MI|US-MID|US-MN|US-MO|US-MP|US-MS|US-MT|US-NC|US-ND|US-NE|US-NH|US-NJ|US-NM|US-NV|US-NY|US-OH|US-OK|US-OR|US-PA|US-PR|US-RI|US-SC|US-SD|US-TN|US-TX|US-UM|US-UT|US-VA|US-VI|US-VT|US-WA|US-WI|US-WV|US-WY|USA|UT|UZB|Udmurt Republic|Uganda, Republic of|Ukraine|Ulyanovsk Oblast|United Arab Emirates|United Kingdom|United States Minor Outlying Islands|Uruguay, Eastern Republic of|Utah|Uttar Pradesh|Uttarakhand|Uzbekistan, Republic of|VA|VAT|VCT|VE|VEN|VER|VGB|VGG|VI|VIC|VIR|VLA|VLG|VNM|VOR|VT|VUT|Vanuatu, Republic of|Vatican|Venezuela, Bolivarian Republic of|Veracruz|Vermont|Victoria|Vietnam, Socialist Republic of|Virgin Islands of the United States|Virginia, Commonwealth of|Vladimir Oblast|Volgograd Oblast|Vologda Oblast|Voronezh Oblast|WA|WAK|WB|WI|WLF|WSM|WV|WY|Wallis and Futuna, Collectivity of the|Washington|West Bengal|West Virginia|Western Australia|Western Sahara|Wisconsin|Wyoming|XJ|XZ|Xinjiang Uyghur Autonomous Region|Xizang Autonomous Region|YAN|YAR|YEM|YEV|YN|YT|YU|YUC|Yamalo-Nenets|Yaroslavl Oblast|Yemen, Republic of|Yucatan|Yukon|Yunnan Province|ZA|ZAB|ZAC|ZAF|ZJ|ZMB|ZWE|Zabaykalsky Krai|Zacatecas|Zambia, Republic of|Zhejiang Province|Zimbabwe, Republic of) )?[ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjklmnpqrstuvwxyz\\d]{2,}\\.[ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjklmnpqrstuvwxyz\\d]{2,}(-\\d{1,8})?/g",
  // https://www.npmjs.com/package/scoped-regex
  "scoped-regex": "/@[a-z\\d][\\w-.]+/[a-z\\d][\\w-.]*/",
  // https://www.npmjs.com/package/semver-regex
  "semver-regex":
    "/(?<=^v?|\\sv?)(?:(?:0|[1-9]\\d{0,9}?)\\.){2}(?:0|[1-9]\\d{0,9})(?:-(?:--+)?(?:0|[1-9]\\d*|\\d*[a-z]+\\d*)){0,100}(?=$| |\\+|\\.)(?:(?<=-\\S+)(?:\\.(?:--?|[\\da-z-]*[a-z-]\\d*|0|[1-9]\\d*)){1,100}?)?(?!\\.)(?:\\+(?:[\\da-z]\\.?-?){1,100}?(?!\\w))?(?!\\+)/gi",
  // https://www.npmjs.com/package/shebang-regex
  "shebang-regex": "/^#!(.*)/",
};
