/*
 * Copyright (C) 2005 Red Hat, Inc. All rights reserved.
 *
 * This file is part of LVM2.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License v.2.1.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _LVM_PV_ALLOC_H

#include <inttypes.h>

struct dm_list;
struct dm_pool;
struct lv_segment;
struct physical_volume;
struct pv_segment;
struct volume_group;

int alloc_pv_segment_whole_pv(struct dm_pool *mem, struct physical_volume *pv);
struct pv_segment *assign_peg_to_lvseg(struct physical_volume *pv, uint32_t pe,
				       uint32_t area_len,
				       struct lv_segment *seg,
				       uint32_t area_num);
int discard_pv_segment(struct pv_segment *peg, uint32_t discard_area_reduction);
int release_pv_segment(struct pv_segment *peg, uint32_t area_reduction);
int check_pv_segments(struct volume_group *vg);
void merge_pv_segments(struct pv_segment *peg1, struct pv_segment *peg2);

#endif
