/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.LocationEnumeration;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

public class InheritingEnvironment
extends SimpleEnvironment {
    int numInherited;
    Environment[] inherited;
    Namespace[] namespaceMap;
    Object[] propertyMap;
    int baseTimestamp;

    public InheritingEnvironment(String name, Environment parent) {
        super(name);
        this.addParent(parent);
        if (parent instanceof SimpleEnvironment) {
            int timestamp;
            this.baseTimestamp = timestamp = ++((SimpleEnvironment)parent).currentTimestamp;
            this.currentTimestamp = timestamp;
        }
    }

    public final int getNumParents() {
        return this.numInherited;
    }

    public final Environment getParent(int index) {
        return this.inherited[index];
    }

    public void addParent(Environment env) {
        if (this.numInherited == 0) {
            this.inherited = new Environment[4];
        } else if (this.numInherited <= this.inherited.length) {
            Environment[] newInherited = new Environment[2 * this.numInherited];
            System.arraycopy(this.inherited, 0, newInherited, 0, this.numInherited);
            this.inherited = newInherited;
        }
        this.inherited[this.numInherited] = env;
        ++this.numInherited;
    }

    public NamedLocation lookupInherited(Symbol name, Object property, int hash) {
        for (int i = 0; i < this.numInherited; ++i) {
            NamedLocation loc;
            Symbol sym = name;
            Object prop = property;
            if (this.namespaceMap != null && this.namespaceMap.length > 2 * i) {
                Namespace srcNamespace = this.namespaceMap[2 * i];
                Namespace dstNamespace = this.namespaceMap[2 * i + 1];
                if (srcNamespace != null || dstNamespace != null) {
                    if (name.getNamespace() != dstNamespace) continue;
                    sym = Symbol.make(srcNamespace, name.getName());
                }
            }
            if (this.propertyMap != null && this.propertyMap.length > 2 * i) {
                Object srcProperty = this.propertyMap[2 * i];
                Object dstProperty = this.propertyMap[2 * i + 1];
                if (srcProperty != null || dstProperty != null) {
                    if (property != dstProperty) continue;
                    prop = srcProperty;
                }
            }
            if ((loc = this.inherited[i].lookup(sym, prop, hash)) == null || !loc.isBound() || loc instanceof SharedLocation && ((SharedLocation)loc).timestamp >= this.baseTimestamp) continue;
            return loc;
        }
        return null;
    }

    public NamedLocation lookup(Symbol name, Object property, int hash) {
        NamedLocation loc = super.lookup(name, property, hash);
        if (loc != null && loc.isBound()) {
            return loc;
        }
        return this.lookupInherited(name, property, hash);
    }

    public synchronized NamedLocation getLocation(Symbol name, Object property, int hash, boolean create) {
        NamedLocation loc = this.lookupDirect(name, property, hash);
        if (loc != null && (create || loc.isBound())) {
            return loc;
        }
        loc = (this.flags & 0x20) != 0 && create ? this.inherited[0].getLocation(name, property, hash, true) : this.lookupInherited(name, property, hash);
        if (loc != null) {
            if (create) {
                NamedLocation xloc = this.addUnboundLocation(name, property, hash);
                if ((this.flags & 1) == 0 && loc.isBound()) {
                    this.redefineError(name, property, xloc);
                }
                xloc.base = loc;
                xloc.value = loc.value == IndirectableLocation.INDIRECT_FLUIDS ? loc.value : ((this.flags & 0x10) != 0 ? IndirectableLocation.DIRECT_ON_SET : null);
                if (xloc instanceof SharedLocation) {
                    ((SharedLocation)xloc).timestamp = this.baseTimestamp;
                }
                return xloc;
            }
            return loc;
        }
        return create ? this.addUnboundLocation(name, property, hash) : null;
    }

    public LocationEnumeration enumerateAllLocations() {
        LocationEnumeration it = new LocationEnumeration(this.table, 1 << this.log2Size);
        it.env = this;
        if (this.inherited != null && this.inherited.length > 0) {
            it.inherited = this.inherited[0].enumerateAllLocations();
            it.index = 0;
        }
        return it;
    }

    protected boolean hasMoreElements(LocationEnumeration it) {
        if (it.inherited != null) {
            while (true) {
                NamedLocation loc = it.curLoc;
                while (true) {
                    it.inherited.curLoc = loc;
                    if (!it.inherited.hasMoreElements()) break;
                    loc = it.inherited.curLoc;
                    if (this.lookup(loc.name, loc.property) == loc) {
                        it.curLoc = loc;
                        return true;
                    }
                    loc = loc.next;
                }
                it.curLoc = it.inherited.curLoc;
                if (++it.index == this.numInherited) break;
                it.inherited = this.inherited[it.index].enumerateAllLocations();
            }
            it.inherited = null;
            it.bindings = this.table;
            it.index = 1 << this.log2Size;
        }
        return super.hasMoreElements(it);
    }

    protected void toStringBase(StringBuffer sbuf) {
        sbuf.append(" baseTs:");
        sbuf.append(this.baseTimestamp);
        for (int i = 0; i < this.numInherited; ++i) {
            sbuf.append(" base:");
            sbuf.append(this.inherited[i].toStringVerbose());
        }
    }
}

