# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementBlobContainersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_list(self, resource_group):
        response = self.client.blob_containers.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_create(self, resource_group):
        response = self.client.blob_containers.create(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            blob_container={
                "defaultEncryptionScope": "str",
                "deleted": bool,
                "deletedTime": "2020-02-20 00:00:00",
                "denyEncryptionScopeOverride": bool,
                "enableNfsV3AllSquash": bool,
                "enableNfsV3RootSquash": bool,
                "etag": "str",
                "hasImmutabilityPolicy": bool,
                "hasLegalHold": bool,
                "id": "str",
                "immutabilityPolicy": {
                    "allowProtectedAppendWrites": bool,
                    "allowProtectedAppendWritesAll": bool,
                    "etag": "str",
                    "immutabilityPeriodSinceCreationInDays": 0,
                    "state": "str",
                    "updateHistory": [
                        {
                            "allowProtectedAppendWrites": bool,
                            "allowProtectedAppendWritesAll": bool,
                            "immutabilityPeriodSinceCreationInDays": 0,
                            "objectIdentifier": "str",
                            "tenantId": "str",
                            "timestamp": "2020-02-20 00:00:00",
                            "update": "str",
                            "upn": "str",
                        }
                    ],
                },
                "immutableStorageWithVersioning": {
                    "enabled": bool,
                    "migrationState": "str",
                    "timeStamp": "2020-02-20 00:00:00",
                },
                "lastModifiedTime": "2020-02-20 00:00:00",
                "leaseDuration": "str",
                "leaseState": "str",
                "leaseStatus": "str",
                "legalHold": {
                    "hasLegalHold": bool,
                    "protectedAppendWritesHistory": {
                        "allowProtectedAppendWritesAll": bool,
                        "timestamp": "2020-02-20 00:00:00",
                    },
                    "tags": [
                        {
                            "objectIdentifier": "str",
                            "tag": "str",
                            "tenantId": "str",
                            "timestamp": "2020-02-20 00:00:00",
                            "upn": "str",
                        }
                    ],
                },
                "metadata": {"str": "str"},
                "name": "str",
                "publicAccess": "str",
                "remainingRetentionDays": 0,
                "type": "str",
                "version": "str",
            },
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_update(self, resource_group):
        response = self.client.blob_containers.update(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            blob_container={
                "defaultEncryptionScope": "str",
                "deleted": bool,
                "deletedTime": "2020-02-20 00:00:00",
                "denyEncryptionScopeOverride": bool,
                "enableNfsV3AllSquash": bool,
                "enableNfsV3RootSquash": bool,
                "etag": "str",
                "hasImmutabilityPolicy": bool,
                "hasLegalHold": bool,
                "id": "str",
                "immutabilityPolicy": {
                    "allowProtectedAppendWrites": bool,
                    "allowProtectedAppendWritesAll": bool,
                    "etag": "str",
                    "immutabilityPeriodSinceCreationInDays": 0,
                    "state": "str",
                    "updateHistory": [
                        {
                            "allowProtectedAppendWrites": bool,
                            "allowProtectedAppendWritesAll": bool,
                            "immutabilityPeriodSinceCreationInDays": 0,
                            "objectIdentifier": "str",
                            "tenantId": "str",
                            "timestamp": "2020-02-20 00:00:00",
                            "update": "str",
                            "upn": "str",
                        }
                    ],
                },
                "immutableStorageWithVersioning": {
                    "enabled": bool,
                    "migrationState": "str",
                    "timeStamp": "2020-02-20 00:00:00",
                },
                "lastModifiedTime": "2020-02-20 00:00:00",
                "leaseDuration": "str",
                "leaseState": "str",
                "leaseStatus": "str",
                "legalHold": {
                    "hasLegalHold": bool,
                    "protectedAppendWritesHistory": {
                        "allowProtectedAppendWritesAll": bool,
                        "timestamp": "2020-02-20 00:00:00",
                    },
                    "tags": [
                        {
                            "objectIdentifier": "str",
                            "tag": "str",
                            "tenantId": "str",
                            "timestamp": "2020-02-20 00:00:00",
                            "upn": "str",
                        }
                    ],
                },
                "metadata": {"str": "str"},
                "name": "str",
                "publicAccess": "str",
                "remainingRetentionDays": 0,
                "type": "str",
                "version": "str",
            },
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_get(self, resource_group):
        response = self.client.blob_containers.get(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_delete(self, resource_group):
        response = self.client.blob_containers.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_set_legal_hold(self, resource_group):
        response = self.client.blob_containers.set_legal_hold(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            legal_hold={"tags": ["str"], "allowProtectedAppendWritesAll": bool, "hasLegalHold": bool},
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_clear_legal_hold(self, resource_group):
        response = self.client.blob_containers.clear_legal_hold(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            legal_hold={"tags": ["str"], "allowProtectedAppendWritesAll": bool, "hasLegalHold": bool},
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_create_or_update_immutability_policy(self, resource_group):
        response = self.client.blob_containers.create_or_update_immutability_policy(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            immutability_policy_name="default",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_get_immutability_policy(self, resource_group):
        response = self.client.blob_containers.get_immutability_policy(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            immutability_policy_name="default",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_delete_immutability_policy(self, resource_group):
        response = self.client.blob_containers.delete_immutability_policy(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            if_match="str",
            immutability_policy_name="default",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_lock_immutability_policy(self, resource_group):
        response = self.client.blob_containers.lock_immutability_policy(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            if_match="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_extend_immutability_policy(self, resource_group):
        response = self.client.blob_containers.extend_immutability_policy(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            if_match="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_lease(self, resource_group):
        response = self.client.blob_containers.lease(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_blob_containers_begin_object_level_worm(self, resource_group):
        response = self.client.blob_containers.begin_object_level_worm(
            resource_group_name=resource_group.name,
            account_name="str",
            container_name="str",
            api_version="2025-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
