<?php

/*
 * This file is part of the Predis package.
 *
 * (c) 2009-2020 Daniele Alessandri
 * (c) 2021-2026 Till Krüss
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Predis\Retry\Strategy;

/**
 * Equal backoff between retry.
 */
class EqualBackoff implements RetryStrategyInterface
{
    /**
     * @var int
     */
    protected $backoff;

    /**
     * @param int $backoff in micro seconds
     */
    public function __construct(int $backoff)
    {
        $this->backoff = $backoff;
    }

    public function compute(int $failures): int
    {
        return $this->backoff;
    }
}
