/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2022-2025 Rockchip Electronics Co., Ltd.
 * Author: Finley Xiao <finley.xiao@rock-chips.com>
 */

#ifndef _DT_BINDINGS_CLK_ROCKCHIP_RK3562_H
#define _DT_BINDINGS_CLK_ROCKCHIP_RK3562_H

/* cru-clocks indices */

/* cru plls */
#define PLL_DMPLL0			0
#define PLL_APLL			1
#define PLL_GPLL			2
#define PLL_VPLL			3
#define PLL_HPLL			4
#define PLL_CPLL			5
#define PLL_DPLL			6
#define PLL_DMPLL1			7

/* cru clocks */
#define ARMCLK				8
#define CLK_GPU				9
#define ACLK_RKNN			10
#define CLK_DDR				11
#define CLK_MATRIX_50M_SRC		12
#define CLK_MATRIX_100M_SRC		13
#define CLK_MATRIX_125M_SRC		14
#define CLK_MATRIX_200M_SRC		15
#define CLK_MATRIX_300M_SRC		16
#define ACLK_TOP			17
#define ACLK_TOP_VIO			18
#define CLK_CAM0_OUT2IO			19
#define CLK_CAM1_OUT2IO			20
#define CLK_CAM2_OUT2IO			21
#define CLK_CAM3_OUT2IO			22
#define ACLK_BUS			23
#define HCLK_BUS			24
#define PCLK_BUS			25
#define PCLK_I2C1			26
#define PCLK_I2C2			27
#define PCLK_I2C3			28
#define PCLK_I2C4			29
#define PCLK_I2C5			30
#define CLK_I2C				31
#define CLK_I2C1			32
#define CLK_I2C2			33
#define CLK_I2C3			34
#define CLK_I2C4			35
#define CLK_I2C5			36
#define DCLK_BUS_GPIO			37
#define DCLK_BUS_GPIO3			38
#define DCLK_BUS_GPIO4			39
#define PCLK_TIMER			40
#define CLK_TIMER0			41
#define CLK_TIMER1			42
#define CLK_TIMER2			43
#define CLK_TIMER3			44
#define CLK_TIMER4			45
#define CLK_TIMER5			46
#define PCLK_STIMER			47
#define CLK_STIMER0			48
#define CLK_STIMER1			49
#define PCLK_WDTNS			50
#define CLK_WDTNS			51
#define PCLK_GRF			52
#define PCLK_SGRF			53
#define PCLK_MAILBOX			54
#define PCLK_INTC			55
#define ACLK_BUS_GIC400			56
#define ACLK_BUS_SPINLOCK		57
#define ACLK_DCF			58
#define PCLK_DCF			59
#define FCLK_BUS_CM0_CORE		60
#define CLK_BUS_CM0_RTC			61
#define HCLK_ICACHE			62
#define HCLK_DCACHE			63
#define PCLK_TSADC			64
#define CLK_TSADC			65
#define CLK_TSADC_TSEN			66
#define PCLK_DFT2APB			67
#define CLK_SARADC_VCCIO156		68
#define PCLK_GMAC			69
#define ACLK_GMAC			70
#define CLK_GMAC_125M_CRU_I		71
#define CLK_GMAC_50M_CRU_I		72
#define CLK_GMAC_50M_O			73
#define CLK_GMAC_ETH_OUT2IO		74
#define PCLK_APB2ASB_VCCIO156		75
#define PCLK_TO_VCCIO156		76
#define PCLK_DSIPHY			77
#define PCLK_DSITX			78
#define PCLK_CPU_EMA_DET		79
#define PCLK_HASH			80
#define PCLK_TOPCRU			81
#define PCLK_ASB2APB_VCCIO156		82
#define PCLK_IOC_VCCIO156		83
#define PCLK_GPIO3_VCCIO156		84
#define PCLK_GPIO4_VCCIO156		85
#define PCLK_SARADC_VCCIO156		86
#define PCLK_MAC100			87
#define ACLK_MAC100			89
#define CLK_MAC100_50M_MATRIX		90
#define HCLK_CORE			91
#define PCLK_DDR			92
#define CLK_MSCH_BRG_BIU		93
#define PCLK_DDR_HWLP			94
#define PCLK_DDR_UPCTL			95
#define PCLK_DDR_PHY			96
#define PCLK_DDR_DFICTL			97
#define PCLK_DDR_DMA2DDR		98
#define PCLK_DDR_MON			99
#define TMCLK_DDR_MON			100
#define PCLK_DDR_GRF			101
#define PCLK_DDR_CRU			102
#define PCLK_SUBDDR_CRU			103
#define CLK_GPU_PRE			104
#define ACLK_GPU_PRE			105
#define CLK_GPU_BRG			107
#define CLK_NPU_PRE			108
#define HCLK_NPU_PRE			109
#define HCLK_RKNN			111
#define ACLK_PERI			112
#define HCLK_PERI			113
#define PCLK_PERI			114
#define PCLK_PERICRU			115
#define HCLK_SAI0			116
#define CLK_SAI0_SRC			117
#define CLK_SAI0_FRAC			118
#define CLK_SAI0			119
#define MCLK_SAI0			120
#define MCLK_SAI0_OUT2IO		121
#define HCLK_SAI1			122
#define CLK_SAI1_SRC			123
#define CLK_SAI1_FRAC			124
#define CLK_SAI1			125
#define MCLK_SAI1			126
#define MCLK_SAI1_OUT2IO		127
#define HCLK_SAI2			128
#define CLK_SAI2_SRC			129
#define CLK_SAI2_FRAC			130
#define CLK_SAI2			131
#define MCLK_SAI2			132
#define MCLK_SAI2_OUT2IO		133
#define HCLK_DSM			134
#define CLK_DSM				135
#define HCLK_PDM			136
#define MCLK_PDM			137
#define HCLK_SPDIF			138
#define CLK_SPDIF_SRC			139
#define CLK_SPDIF_FRAC			140
#define CLK_SPDIF			141
#define MCLK_SPDIF			142
#define HCLK_SDMMC0			143
#define CCLK_SDMMC0			144
#define HCLK_SDMMC1			145
#define CCLK_SDMMC1			146
#define SCLK_SDMMC0_DRV			147
#define SCLK_SDMMC0_SAMPLE		148
#define SCLK_SDMMC1_DRV			149
#define SCLK_SDMMC1_SAMPLE		150
#define HCLK_EMMC			151
#define ACLK_EMMC			152
#define CCLK_EMMC			153
#define BCLK_EMMC			154
#define TMCLK_EMMC			155
#define SCLK_SFC			156
#define HCLK_SFC			157
#define HCLK_USB2HOST			158
#define HCLK_USB2HOST_ARB		159
#define PCLK_SPI1			160
#define CLK_SPI1			161
#define SCLK_IN_SPI1			162
#define PCLK_SPI2			163
#define CLK_SPI2			164
#define SCLK_IN_SPI2			165
#define PCLK_UART1			166
#define PCLK_UART2			167
#define PCLK_UART3			168
#define PCLK_UART4			169
#define PCLK_UART5			170
#define PCLK_UART6			171
#define PCLK_UART7			172
#define PCLK_UART8			173
#define PCLK_UART9			174
#define CLK_UART1_SRC			175
#define CLK_UART1_FRAC			176
#define CLK_UART1			177
#define SCLK_UART1			178
#define CLK_UART2_SRC			179
#define CLK_UART2_FRAC			180
#define CLK_UART2			181
#define SCLK_UART2			182
#define CLK_UART3_SRC			183
#define CLK_UART3_FRAC			184
#define CLK_UART3			185
#define SCLK_UART3			186
#define CLK_UART4_SRC			187
#define CLK_UART4_FRAC			188
#define CLK_UART4			189
#define SCLK_UART4			190
#define CLK_UART5_SRC			191
#define CLK_UART5_FRAC			192
#define CLK_UART5			193
#define SCLK_UART5			194
#define CLK_UART6_SRC			195
#define CLK_UART6_FRAC			196
#define CLK_UART6			197
#define SCLK_UART6			198
#define CLK_UART7_SRC			199
#define CLK_UART7_FRAC			200
#define CLK_UART7			201
#define SCLK_UART7			202
#define CLK_UART8_SRC			203
#define CLK_UART8_FRAC			204
#define CLK_UART8			205
#define SCLK_UART8			206
#define CLK_UART9_SRC			207
#define CLK_UART9_FRAC			208
#define CLK_UART9			209
#define SCLK_UART9			210
#define PCLK_PWM1_PERI			211
#define CLK_PWM1_PERI			212
#define CLK_CAPTURE_PWM1_PERI		213
#define PCLK_PWM2_PERI			214
#define CLK_PWM2_PERI			215
#define CLK_CAPTURE_PWM2_PERI		216
#define PCLK_PWM3_PERI			217
#define CLK_PWM3_PERI			218
#define CLK_CAPTURE_PWM3_PERI		219
#define PCLK_CAN0			220
#define CLK_CAN0			221
#define PCLK_CAN1			222
#define CLK_CAN1			223
#define ACLK_CRYPTO			224
#define HCLK_CRYPTO			225
#define PCLK_CRYPTO			226
#define CLK_CORE_CRYPTO			227
#define CLK_PKA_CRYPTO			228
#define HCLK_KLAD			229
#define PCLK_KEY_READER			230
#define HCLK_RK_RNG_NS			231
#define HCLK_RK_RNG_S			232
#define HCLK_TRNG_NS			233
#define HCLK_TRNG_S			234
#define HCLK_CRYPTO_S			235
#define PCLK_PERI_WDT			236
#define TCLK_PERI_WDT			237
#define ACLK_SYSMEM			238
#define HCLK_BOOTROM			239
#define PCLK_PERI_GRF			240
#define ACLK_DMAC			241
#define ACLK_RKDMAC			242
#define PCLK_OTPC_NS			243
#define CLK_SBPI_OTPC_NS		244
#define CLK_USER_OTPC_NS		245
#define PCLK_OTPC_S			246
#define CLK_SBPI_OTPC_S			247
#define CLK_USER_OTPC_S			248
#define CLK_OTPC_ARB			249
#define PCLK_OTPPHY			250
#define PCLK_USB2PHY			251
#define PCLK_PIPEPHY			252
#define PCLK_SARADC			253
#define CLK_SARADC			254
#define PCLK_IOC_VCCIO234		255
#define PCLK_PERI_GPIO1			256
#define PCLK_PERI_GPIO2			257
#define DCLK_PERI_GPIO			258
#define DCLK_PERI_GPIO1			259
#define DCLK_PERI_GPIO2			260
#define ACLK_PHP			261
#define PCLK_PHP			262
#define ACLK_PCIE20_MST			263
#define ACLK_PCIE20_SLV			264
#define ACLK_PCIE20_DBI			265
#define PCLK_PCIE20			266
#define CLK_PCIE20_AUX			267
#define ACLK_USB3OTG			268
#define CLK_USB3OTG_SUSPEND		269
#define CLK_USB3OTG_REF			270
#define CLK_PIPEPHY_REF_FUNC		271
#define CLK_200M_PMU			272
#define CLK_RTC_32K			273
#define CLK_RTC32K_FRAC			274
#define BUSCLK_PDPMU0			275
#define PCLK_PMU0_CRU			276
#define PCLK_PMU0_PMU			277
#define CLK_PMU0_PMU			278
#define PCLK_PMU0_HP_TIMER		279
#define CLK_PMU0_HP_TIMER		280
#define CLK_PMU0_32K_HP_TIMER		281
#define PCLK_PMU0_PVTM			282
#define CLK_PMU0_PVTM			283
#define PCLK_IOC_PMUIO			284
#define PCLK_PMU0_GPIO0			285
#define DBCLK_PMU0_GPIO0		286
#define PCLK_PMU0_GRF			287
#define PCLK_PMU0_SGRF			288
#define CLK_DDR_FAIL_SAFE		289
#define PCLK_PMU0_SCRKEYGEN		290
#define PCLK_PMU1_CRU			291
#define HCLK_PMU1_MEM			292
#define PCLK_PMU0_I2C0			293
#define CLK_PMU0_I2C0			294
#define PCLK_PMU1_UART0			295
#define CLK_PMU1_UART0_SRC		296
#define CLK_PMU1_UART0_FRAC		297
#define CLK_PMU1_UART0			298
#define SCLK_PMU1_UART0			299
#define PCLK_PMU1_SPI0			300
#define CLK_PMU1_SPI0			301
#define SCLK_IN_PMU1_SPI0		302
#define PCLK_PMU1_PWM0			303
#define CLK_PMU1_PWM0			304
#define CLK_CAPTURE_PMU1_PWM0		305
#define CLK_PMU1_WIFI			306
#define FCLK_PMU1_CM0_CORE		307
#define CLK_PMU1_CM0_RTC		308
#define PCLK_PMU1_WDTNS			309
#define CLK_PMU1_WDTNS			310
#define PCLK_PMU1_MAILBOX		311
#define CLK_PIPEPHY_DIV			312
#define CLK_PIPEPHY_XIN24M		313
#define CLK_PIPEPHY_REF			314
#define CLK_24M_SSCSRC			315
#define CLK_USB2PHY_XIN24M		316
#define CLK_USB2PHY_REF			317
#define CLK_MIPIDSIPHY_XIN24M		318
#define CLK_MIPIDSIPHY_REF		319
#define ACLK_RGA_PRE			320
#define HCLK_RGA_PRE			321
#define ACLK_RGA			322
#define HCLK_RGA			323
#define CLK_RGA_CORE			324
#define ACLK_JDEC			325
#define HCLK_JDEC			326
#define ACLK_VDPU_PRE			327
#define CLK_RKVDEC_HEVC_CA		328
#define HCLK_VDPU_PRE			329
#define ACLK_RKVDEC			330
#define HCLK_RKVDEC			331
#define CLK_RKVENC_CORE			332
#define ACLK_VEPU_PRE			333
#define HCLK_VEPU_PRE			334
#define ACLK_RKVENC			335
#define HCLK_RKVENC			336
#define ACLK_VI				337
#define HCLK_VI				338
#define PCLK_VI				339
#define ACLK_ISP			340
#define HCLK_ISP			341
#define CLK_ISP				342
#define ACLK_VICAP			343
#define HCLK_VICAP			344
#define DCLK_VICAP			345
#define CSIRX0_CLK_DATA			346
#define CSIRX1_CLK_DATA			347
#define CSIRX2_CLK_DATA			348
#define CSIRX3_CLK_DATA			349
#define PCLK_CSIHOST0			350
#define PCLK_CSIHOST1			351
#define PCLK_CSIHOST2			352
#define PCLK_CSIHOST3			353
#define PCLK_CSIPHY0			354
#define PCLK_CSIPHY1			355
#define ACLK_VO_PRE			356
#define HCLK_VO_PRE			357
#define ACLK_VOP			358
#define HCLK_VOP			359
#define DCLK_VOP			360
#define DCLK_VOP1			361
#define ACLK_CRYPTO_S			362
#define PCLK_CRYPTO_S			363
#define CLK_CORE_CRYPTO_S		364
#define CLK_PKA_CRYPTO_S		365

#endif
