$ora_debug = shift if $ARGV[0] =~ /-#/;

(($base = shift) &&
 ($user = shift) &&
 ($pass = shift)) || die "Usage: $0 base user pass\n";

$lda = &ora_login($base, $user, $pass) || die "$ora_errstr\n";

format STDOUT_TOP =
       Name         Ext
       ====         ===
.

format STDOUT =
       @<<<<<<<<<   @>>
       $name,       $ext
.

# function to list the database

sub list
{
	local($csr, $name, $ext);

	$- = 0;

	$csr = &ora_open($lda, $LIST)			|| die $ora_errstr;
	$nfields = &ora_fetch($csr)			|| die $ora_errstr;
	print "$nfields fields, lengths ", join(', ', &ora_lengths($csr)), "\n";
	print "\ttypes ", join(', ', &ora_types($csr)), "\n";
	print "\tnames ", join(', ', &ora_titles($csr, 0)), "\n";

	while (($name, $ext) = &ora_fetch($csr))
	{
		grep(defined || ($_ = '<-NULL->'), $name, $ext);
		write;
	}
	die $ora_errstr if ($ora_errno != 0);
	do ora_close($csr)				|| die $ora_errstr;
}

# set these as strings to make the code more readable
$CREATE = "create table tryit (name char(10), ext number(3))";
$INSERT = "insert into tryit values (:1, :2)";
$LIST	= "select * from tryit order by name";
$DELETE	= "delete from tryit where name = :1";
$DROP	= "drop table tryit";

# create the database

&ora_do($lda, $CREATE)				|| die $ora_errstr;

# put some data into it

$csr = &ora_open($lda, $INSERT)			|| die $ora_errstr;
while (<DATA>)
{
	chop;
	($name, $telno) = split(':', $_);
	undef $name if $name eq 'NULL';
	undef $telno if $telno eq 'NULL';

	do ora_bind($csr, $name, $telno);
}
do ora_close($csr)				|| die $ora_errstr;

# check the result
do list();

# remove a few lines

$csr = &ora_open($lda, $DELETE)			|| die $ora_errstr;
foreach $name ('catherine', 'angela', 'arnold', 'julia')
{
	&ora_bind($csr, $name)			|| die $ora_errstr;
}
&ora_close($csr)				|| die $ora_errstr;
&ora_do($lda, 'delete from tryit where name is null')	|| die $ora_errstr;

# check the result
do list();

# remove the database and log out
do ora_do($lda, $DROP)				|| die $ora_errstr;
do ora_logoff($lda)				|| die $ora_errstr;

# This is the data which will go into the database
__END__
julia:292
angela:208
larry:424
catherine:201
randal:306
arnold:305
NULL:999
nonumber:NULL
NULL:NULL
