# Map endpoints to subroutine names in Core::V1.
use strict;
{
    'api/1.0/admin/cluster GET' => 'get_cluster_information',
    'api/1.0/admin/groups DELETE' => 'delete_group',
    'api/1.0/admin/groups GET' => 'get_groups',
    'api/1.0/admin/groups POST' => 'create_group',
    'api/1.0/admin/groups/add-user POST' => 'add_user_to_group',
    'api/1.0/admin/groups/add-users POST' => 'add_users_to_group',
    'api/1.0/admin/groups/more-members GET' => 'find_users_in_group',
    'api/1.0/admin/groups/more-non-members GET' => 'find_users_not_in_group',
    'api/1.0/admin/groups/remove-user POST' => 'remove_user_from_group',
    'api/1.0/admin/license GET' => 'get_license',
    'api/1.0/admin/license POST' => 'update_license',
    'api/1.0/admin/mail-server DELETE' => 'delete_mail_config',
    'api/1.0/admin/mail-server GET' => 'get_mail_config',
    'api/1.0/admin/mail-server PUT' => 'set_mail_config',
    'api/1.0/admin/mail-server/sender-address DELETE' => 'clear_sender_address',
    'api/1.0/admin/mail-server/sender-address GET' => 'get_sender_address',
    'api/1.0/admin/mail-server/sender-address PUT' => 'set_sender_address',
    'api/1.0/admin/permissions/groups DELETE' => 'revoke_permissions_for_group',
    'api/1.0/admin/permissions/groups GET' => 'get_groups_with_any_permission',
    'api/1.0/admin/permissions/groups PUT' => 'set_permission_for_groups',
    'api/1.0/admin/permissions/groups/none GET' => 'get_groups_without_any_permission',
    'api/1.0/admin/permissions/users DELETE' => 'revoke_permissions_for_user',
    'api/1.0/admin/permissions/users GET' => 'get_users_with_any_permission',
    'api/1.0/admin/permissions/users PUT' => 'set_permission_for_users',
    'api/1.0/admin/permissions/users/none GET' => 'get_users_without_any_permission',
    'api/1.0/admin/pull-requests/{scmId} GET' => 'get_merge_config',
    'api/1.0/admin/pull-requests/{scmId} POST' => 'set_merge_config',
    'api/1.0/admin/users DELETE' => 'delete_user',
    'api/1.0/admin/users GET' => 'get_users',
    'api/1.0/admin/users POST' => 'create_user',
    'api/1.0/admin/users PUT' => 'update_user_details',
    'api/1.0/admin/users/add-group POST' => 'add_group_to_user',
    'api/1.0/admin/users/add-groups POST' => 'add_user_to_groups',
    'api/1.0/admin/users/captcha DELETE' => 'clear_user_captcha_challenge',
    'api/1.0/admin/users/credentials PUT' => 'update_user_password',
    'api/1.0/admin/users/more-members GET' => 'find_groups_for_user',
    'api/1.0/admin/users/more-non-members GET' => 'find_other_groups_for_user',
    'api/1.0/admin/users/remove-group POST' => 'remove_group_from_user',
    'api/1.0/admin/users/rename POST' => 'rename_user',
    'api/1.0/application-properties GET' => 'get_application_properties',
    'api/1.0/dashboard/pull-request-suggestions GET' => 'get_dashboard_pull_request_suggestions',
    'api/1.0/dashboard/pull-requests GET' => 'get_dashboard_pull_requests',
    'api/1.0/groups GET' => 'get_group_names',
    'api/1.0/hooks/{hookKey}/avatar GET' => 'get_avatar',
    'api/1.0/inbox/pull-requests GET' => 'get_inbox_pull_requests',
    'api/1.0/inbox/pull-requests/count GET' => 'get_inbox_pull_request_count',
    'api/1.0/logs/logger/{loggerName} GET' => 'get_level',
    'api/1.0/logs/logger/{loggerName}/{levelName} PUT' => 'set_level',
    'api/1.0/logs/rootLogger GET' => 'get_root_level',
    'api/1.0/logs/rootLogger/{levelName} PUT' => 'set_root_level',
    'api/1.0/markup/preview POST' => 'preview',
    'api/1.0/profile/recent/repos GET' => 'get_repositories_recently_accessed',
    'api/1.0/projects GET' => 'get_projects',
    'api/1.0/projects POST' => 'create_project',
    'api/1.0/projects/{projectKey} DELETE' => 'delete_project',
    'api/1.0/projects/{projectKey} GET' => 'get_project',
    'api/1.0/projects/{projectKey} PUT' => 'update_project',
    'api/1.0/projects/{projectKey}/avatar.png GET' => 'get_project_avatar',
    'api/1.0/projects/{projectKey}/avatar.png POST' => 'upload_project_avatar',
    'api/1.0/projects/{projectKey}/permissions/groups DELETE' => 'revoke_project_permissions_for_group',
    'api/1.0/projects/{projectKey}/permissions/groups GET' => 'get_groups_with_any_project_permission',
    'api/1.0/projects/{projectKey}/permissions/groups PUT' => 'set_project_permission_for_groups',
    'api/1.0/projects/{projectKey}/permissions/groups/none GET' => 'get_groups_without_any_project_permission',
    'api/1.0/projects/{projectKey}/permissions/users DELETE' => 'revoke_project_permissions_for_user',
    'api/1.0/projects/{projectKey}/permissions/users GET' => 'get_users_with_any_project_permission',
    'api/1.0/projects/{projectKey}/permissions/users PUT' => 'set_project_permission_for_users',
    'api/1.0/projects/{projectKey}/permissions/users/none GET' => 'get_users_without_project_permission',
    'api/1.0/projects/{projectKey}/permissions/{permission}/all GET' => 'has_all_user_project_permission',
    'api/1.0/projects/{projectKey}/permissions/{permission}/all POST' => 'modify_all_user_project_permission',
    'api/1.0/projects/{projectKey}/repos GET' => 'get_repositories',
    'api/1.0/projects/{projectKey}/repos POST' => 'create_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug} DELETE' => 'delete_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug} GET' => 'get_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug} POST' => 'fork_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug} PUT' => 'update_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/archive GET' => 'get_archive',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches GET' => 'get_branches',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches POST' => 'create_branch',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default GET' => 'get_default_branch',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/branches/default PUT' => 'set_default_branch',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*} GET' => 'get_file',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/browse/{path:.*} PUT' => 'edit_file',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/changes GET' => 'get_repository_changes',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits GET' => 'get_repository_commits',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId} GET' => 'get_commit',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/changes GET' => 'get_commit_changes',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments GET' => 'get_commit_comments',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments POST' => 'create_commit_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId} DELETE' => 'delete_commit_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId} GET' => 'get_commit_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId} PUT' => 'update_commit_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff/{path:.*} GET' => 'stream_commit_diff',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch DELETE' => 'unwatch_commit',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch POST' => 'watch_commit',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/changes GET' => 'stream_changes',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/commits GET' => 'stream_commits',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/compare/diff{path:.*} GET' => 'stream_diff',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/diff/{path:.*} GET' => 'stream_repository_diff',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/files GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/files/{path:.*} GET' => 'get_repository_files',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/forks GET' => 'get_forked_repositories',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/last-modified/{path:.*} GET' => 'stream_last_modified',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/participants GET' => 'get_repository_participants',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups DELETE' => 'revoke_repository_permissions_for_group',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups GET' => 'get_groups_with_any_repository_permission',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups PUT' => 'set_repository_permission_for_group',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/groups/none GET' => 'get_groups_without_any_repository_permission',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users DELETE' => 'revoke_repository_permissions_for_user',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users GET' => 'get_users_with_any_repository_permission',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users PUT' => 'set_repository_permission_for_user',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/permissions/users/none GET' => 'get_users_without_repository_permission',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests GET' => 'get_pull_requests',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests POST' => 'create_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId} DELETE' => 'delete_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId} GET' => 'get_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId} PUT' => 'update_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/activities GET' => 'get_pull_request_activities',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve DELETE' => 'withdraw_pull_request_approval',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve POST' => 'approve_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes GET' => 'stream_pull_request_changes',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments GET' => 'get_pull_request_comments',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments POST' => 'create_pull_request_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId} DELETE' => 'delete_pull_request_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId} GET' => 'get_pull_request_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId} PUT' => 'update_pull_request_comment',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits GET' => 'get_pull_request_commits',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/decline POST' => 'decline_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff/{path:.*} GET' => 'stream_pull_request_diff',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge GET' => 'can_merge_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge POST' => 'merge_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants DELETE' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants GET' => 'get_pull_request_participants',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants POST' => 'assign_participant_role',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} DELETE' => 'unassign_participant_role',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} PUT' => 'update_status',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/reopen POST' => 'reopen_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks GET' => 'get_pull_request_tasks',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/tasks/count GET' => 'count_pull_request_tasks',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch DELETE' => 'unwatch_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch POST' => 'watch_pull_request',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw GET' => '', # Disabled
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/raw/{path:.*} GET' => 'get_content',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/recreate POST' => 'retry_create_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/related GET' => 'get_related_repositories',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks GET' => 'get_repository_hooks',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey} DELETE' => 'delete_repository_hook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey} GET' => 'get_repository_hook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled DELETE' => 'disable_repository_hook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/enabled PUT' => 'enable_repository_hook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings GET' => 'get_repository_hook_settings',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/hooks/{hookKey}/settings PUT' => 'set_repository_hook_settings',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests GET' => 'get_repository_pull_request_settings',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/settings/pull-requests POST' => 'update_repository_pull_request_settings',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags GET' => 'get_tags',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags POST' => 'create_tag',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/tags/{name:.*} GET' => 'get_tag',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch DELETE' => 'unwatch_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/watch POST' => 'watch_repository',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks GET' => 'find_webhooks',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks POST' => 'create_webhook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/test POST' => 'test_webhook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId} DELETE' => 'delete_webhook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId} GET' => 'get_webhook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId} PUT' => 'update_webhook',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/latest GET' => 'get_latest_webhook_invocation',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics GET' => 'get_webhook_statistics',
    'api/1.0/projects/{projectKey}/repos/{repositorySlug}/webhooks/{webhookId}/statistics/summary GET' => 'get_webhook_statistics_summary',
    'api/1.0/projects/{projectKey}/settings/hooks GET' => 'get_repository_hooks_for_project',
    'api/1.0/projects/{projectKey}/settings/hooks/{hookKey} GET' => 'get_repository_hook_for_project',
    'api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled DELETE' => 'disable_repository_hook_for_project',
    'api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/enabled PUT' => 'enable_repository_hook_for_project',
    'api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings GET' => 'get_repository_hook_settings_for_project',
    'api/1.0/projects/{projectKey}/settings/hooks/{hookKey}/settings PUT' => 'set_repository_hook_settings_for_project',
    'api/1.0/projects/{projectKey}/settings/pull-requests/{scmId} GET' => 'get_project_pull_request_settings',
    'api/1.0/projects/{projectKey}/settings/pull-requests/{scmId} POST' => 'update_project_pull_request_settings',
    'api/1.0/repos GET' => 'find_repositories',
    'api/1.0/tasks POST' => 'create_task',
    'api/1.0/tasks/{taskId} DELETE' => 'delete_task',
    'api/1.0/tasks/{taskId} GET' => 'get_task',
    'api/1.0/tasks/{taskId} PUT' => 'update_task',
    'api/1.0/users GET' => 'find_users',
    'api/1.0/users PUT' => 'update_current_user',
    'api/1.0/users/credentials PUT' => 'update_current_user_password',
    'api/1.0/users/{userSlug} GET' => 'get_user',
    'api/1.0/users/{userSlug}/avatar.png DELETE' => 'delete_user_avatar',
    'api/1.0/users/{userSlug}/avatar.png POST' => 'upload_user_avatar',
    'api/1.0/users/{userSlug}/settings GET' => 'get_user_settings',
    'api/1.0/users/{userSlug}/settings POST' => 'update_user_settings',
};
