/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.AppendCommandExecutor;
import org.couchbase.mock.memcached.ArithmeticCommandExecutor;
import org.couchbase.mock.memcached.BinaryProtocolHandler;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.memcached.DeleteCommandExecutor;
import org.couchbase.mock.memcached.FlushCommandExecutor;
import org.couchbase.mock.memcached.GetCommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.NoopCommandExecutor;
import org.couchbase.mock.memcached.PrependCommandExecutor;
import org.couchbase.mock.memcached.QuitCommandExecutor;
import org.couchbase.mock.memcached.SaslCommandExecutor;
import org.couchbase.mock.memcached.StatCommandExecutor;
import org.couchbase.mock.memcached.StoreCommandExecutor;
import org.couchbase.mock.memcached.UnknownCommandExecutor;
import org.couchbase.mock.memcached.VerbosityCommandExecutor;
import org.couchbase.mock.memcached.VersionCommandExecutor;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class MemcachedServer
implements Runnable,
BinaryProtocolHandler {
    private final DataStore datastore;
    private final long bootTime;
    private final String hostname;
    private final ServerSocketChannel server;
    private Selector selector;
    private final int port;
    private CommandExecutor[] executors = new CommandExecutor[255];
    private final Bucket bucket;
    private boolean active = true;
    private int hiccupTime = 0;
    private int hiccupOffset = 0;
    private int truncateLimit = 0;

    public MemcachedServer(Bucket bucket, String hostname, int port, DataStore datastore) throws IOException {
        this.bucket = bucket;
        this.datastore = datastore;
        UnknownCommandExecutor unknownHandler = new UnknownCommandExecutor();
        for (int ii = 0; ii < this.executors.length; ++ii) {
            this.executors[ii] = unknownHandler;
        }
        this.executors[CommandCode.QUIT.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.QUITQ.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.FLUSH.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.FLUSHQ.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.NOOP.cc()] = new NoopCommandExecutor();
        this.executors[CommandCode.VERSION.cc()] = new VersionCommandExecutor();
        this.executors[CommandCode.STAT.cc()] = new StatCommandExecutor();
        this.executors[CommandCode.VERBOSITY.cc()] = new VerbosityCommandExecutor();
        this.executors[CommandCode.ADD.cc()] = new StoreCommandExecutor();
        this.executors[CommandCode.ADDQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.APPEND.cc()] = new AppendCommandExecutor();
        this.executors[CommandCode.APPENDQ.cc()] = new AppendCommandExecutor();
        this.executors[CommandCode.PREPEND.cc()] = new PrependCommandExecutor();
        this.executors[CommandCode.PREPENDQ.cc()] = new PrependCommandExecutor();
        this.executors[CommandCode.SET.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.SETQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACE.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACEQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.DELETE.cc()] = new DeleteCommandExecutor();
        this.executors[CommandCode.DELETEQ.cc()] = this.executors[CommandCode.DELETE.cc()];
        this.executors[CommandCode.GET.cc()] = new GetCommandExecutor();
        this.executors[CommandCode.GETQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETK.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETKQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.TOUCH.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GAT.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GATQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.INCREMENT.cc()] = new ArithmeticCommandExecutor();
        this.executors[CommandCode.INCREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENT.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.SASL_LIST_MECHS.cc()] = new SaslCommandExecutor();
        this.executors[CommandCode.SASL_AUTH.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.executors[CommandCode.SASL_STEP.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.bootTime = System.currentTimeMillis() / 1000L;
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        if (hostname != null && !hostname.equals("*")) {
            this.server.socket().bind(new InetSocketAddress(hostname, port));
            this.hostname = hostname;
        } else {
            this.server.socket().bind(new InetSocketAddress(port));
            InetAddress address = this.server.socket().getInetAddress();
            if (address.isAnyLocalAddress()) {
                String name;
                try {
                    name = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException ex) {
                    name = "localhost";
                }
                this.hostname = name;
            } else {
                this.hostname = address.getHostName();
            }
        }
        this.port = this.server.socket().getLocalPort();
        this.server.register(this.selector, 16);
    }

    public DataStore getDatastore() {
        return this.datastore;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long now = System.currentTimeMillis() / 1000L;
        int uptime = (int)(now - this.bootTime);
        map.put("uptime", new Long(uptime));
        map.put("replication", 1);
        map.put("clusterMembership", "active");
        map.put("status", "healthy");
        map.put("hostname", this.getSocketName());
        map.put("clusterCompatibility", 1);
        map.put("version", "9.9.9");
        StringBuilder sb = new StringBuilder(System.getProperty("os.arch"));
        sb.append("-");
        sb.append(System.getProperty("os.name"));
        sb.append("-");
        sb.append(System.getProperty("os.version"));
        map.put("os", sb.toString().replaceAll(" ", "_"));
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("direct", this.port);
        ports.put("proxy", 0);
        map.put("ports", ports);
        return JSONObject.fromObject(map).toString();
    }

    public Map<String, String> getStats() {
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("pid", Long.toString(Thread.currentThread().getId()));
        stats.put("time", Long.toString(new Date().getTime()));
        stats.put("version", "9.9.9");
        stats.put("uptime", "15554");
        stats.put("accepting_conns", "1");
        stats.put("auth_cmds", "0");
        stats.put("auth_errors", "0");
        stats.put("bucket_active_conns", "1");
        stats.put("bucket_conns", "3");
        stats.put("bytes_read", "1108621");
        stats.put("bytes_written", "205374436");
        stats.put("cas_badval", "0");
        stats.put("cas_hits", "0");
        stats.put("cas_misses", "0");
        return stats;
    }

    public String getSocketName() {
        return this.hostname + ":" + this.port;
    }

    private int writeResponse(SocketChannel channel, ByteBuffer buf) throws IOException, ClosedChannelException {
        int wv;
        int nw = 0;
        do {
            wv = channel.write(buf);
            nw += wv;
        } while (wv > 0);
        if (wv == -1) {
            channel.close();
            throw new ClosedChannelException();
        }
        return nw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.selector.select();
                    if (!this.active) {
                        this.selector.selectedKeys().clear();
                    }
                }
                catch (IOException ex) {}
                continue;
                try {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey key = iterator.next();
                        iterator.remove();
                        MemcachedConnection client = (MemcachedConnection)key.attachment();
                        if (client != null) {
                            try {
                                int ioevents = 1;
                                SocketChannel channel = (SocketChannel)key.channel();
                                if (key.isReadable()) {
                                    if (channel.read(client.getInputBuffer()) == -1) {
                                        channel.close();
                                        throw new ClosedChannelException();
                                    }
                                    client.step();
                                }
                                if (key.isWritable()) {
                                    ByteBuffer buf;
                                    while ((buf = client.getOutputBuffer()) != null) {
                                        if (this.truncateLimit > 0 && buf.limit() > this.truncateLimit) {
                                            buf.limit(this.truncateLimit);
                                        }
                                        if (this.hiccupOffset > 0 && buf.limit() > this.hiccupOffset) {
                                            ByteBuffer immediateBuf = buf.slice();
                                            buf.position(this.hiccupOffset);
                                            immediateBuf.limit(this.hiccupOffset);
                                            this.writeResponse(channel, immediateBuf);
                                            try {
                                                Thread.sleep(this.hiccupTime);
                                            }
                                            catch (InterruptedException exintr) {
                                                // empty catch block
                                            }
                                        }
                                        this.writeResponse(channel, buf);
                                    }
                                }
                                if (client.hasOutput()) {
                                    ioevents |= 4;
                                }
                                channel.register(this.selector, ioevents, client);
                            }
                            catch (ClosedChannelException exp) {
                            }
                            catch (IOException ioexp) {}
                            continue;
                        }
                        if (!key.isAcceptable()) continue;
                        SocketChannel cc = this.server.accept();
                        cc.configureBlocking(false);
                        cc.register(this.selector, 1, new MemcachedConnection(this));
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        finally {
            try {
                this.server.close();
                this.selector.close();
            }
            catch (IOException e) {
                Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedConnection client) throws IOException {
        try {
            if (client.isAuthenticated() || cmd.getComCode() == CommandCode.SASL_AUTH || cmd.getComCode() == CommandCode.SASL_LIST_MECHS || cmd.getComCode() == CommandCode.SASL_STEP) {
                this.executors[cmd.getComCode().cc()].execute(cmd, this, client);
            } else {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.AUTH_ERROR));
            }
        }
        catch (AccessControlException ex) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.NOT_MY_VBUCKET));
        }
    }

    BinaryProtocolHandler getProtocolHandler() {
        return this;
    }

    public void shutdown() {
        this.active = false;
    }

    public void startup() {
        this.active = true;
    }

    public void setHiccup(int msecs, int offset) {
        if (msecs < 0 || offset < 0) {
            throw new IllegalArgumentException("Time and offset must be >= 0");
        }
        this.hiccupTime = msecs;
        this.hiccupOffset = offset;
    }

    public void setTruncateLimit(int limit) {
        this.truncateLimit = limit;
    }

    public static void main(String[] args) {
        try {
            DataStore ds = new DataStore(1024);
            MemcachedServer server = new MemcachedServer(null, null, 11211, ds);
            for (int ii = 0; ii < 1024; ++ii) {
                ds.setOwnership(ii, server);
            }
            server.run();
        }
        catch (IOException e) {
            Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, "Fatal error! failed to create socket: ", e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public Bucket.BucketType getType() {
        return this.bucket.getType();
    }
}

