/*
 * to_faxtransmit.c
 *
 * Copyrighted by J. Chung. (c) 1992
 *
 * This program will create a temp. file. and launch the faxtransmit module
 *
 */
#include <stdio.h>
#include <string.h>

#ifdef DEBUG
#include <sys/types.h>
#endif DEBUG

#ifdef LINT
static char sccsid[] = "@(#)to_faxtransmit.c	1.1 10/5/92";
#endif LINT

/*
 * Change the TMPDIR where you have enough spaces such as /usr/tmp
 */
#define  TMPDIR	"/tmp"

main(argc, argv, envp)
int	argc;
char	*argv[], *envp[];
{
    int i;
    void do_faxtransmit();

#ifdef DEBUG
    /* I like to know who I am and also like to find out Environment variable */
    fprintf(stderr, "Real Uid is %d\n", (int) getuid());
    fprintf(stderr, "Effective Uid is %d\n", (int) geteuid());
    i = 0;
    while (envp[i] != NULL)
        fprintf(stderr, "%s\n", envp[i++]);
#endif DEBUG

    if (argc != 1) {
	fprintf(stderr, "usage: %s\n", argv[0]);
	for (i = 0; i < argc; i++)
            fprintf(stderr, "argno. %d\targument %s", i, argv[i]);
        exit(1);
    }

    (void) do_faxtransmit();

    exit (0);
}

/*
 * do_faxtransmit
 *
 */
void do_faxtransmit()
{
    char *tf, aline[BUFSIZ];
    FILE *ofp;
    void transmit();
    
    /* First I need to create a unique file in /tmp directory */
    if ((tf = tempnam(NULL, "XPRFX")) == NULL) {
        fprintf(stderr, "do_faxtransmit - File name can not be created\n");
        exit(1);
    }
    if ((ofp = fopen(tf, "w")) == NULL) {
	fprintf(stderr, "do_faxtransmit - Temp file can not be created\n");
        exit(1);
    }

    /* Second I need to collect all the input stream into the file */
    while (gets(aline) != NULL) {
        fprintf(ofp, "%s\n", aline);
    }
    (void) fclose(ofp); 

    /* Third I need to transmit using gaxtransmit */
    (void) transmit(tf);

    /* Forth, I need to delete the temprary file */
    (void) unlink(tf);

}

/*
 * transmit
 *
 */
void transmit(thefile)
char	*thefile;
{
    char buf[BUFSIZ];
    char *pstr;

    pstr = (char *)getenv("XPRESSFAX_HOME");

    if (pstr == NULL) {
	fprintf(stderr, "transmit - You need to define XPRESSFAX_HOME first...\n");
	exit(1);
    } else
        sprintf(buf,"%s/bin/faxtransmit %s", pstr, thefile);
	system(buf);
}
/faxtransmit %s", pstr, thefile);
	system(buf);
}
