#!/bin/sh
#
# AUTOROUTER.SH
#
# Usage: autorouter.sh FULL_PATH_TO_INBOUND_FAX_FILE
#
# Authors: Jae Chung (chungj@gnp.com)
#		Wrote the 'faxrouter' code to extract names, etc.
#
#	   John Uhley (uhley@xpressware.com)
#		Wrote this script & integration with XIS ScanWorX.
#
#	
#
# 
# This shell script when defined as the "Filter On Rcpt" shell script
# in the XpressFax faxmail configuration module for the fax administrator
# account.   Once defined (and Filter On Rcpt is set to "Yes") each incoming
# or forwarded fax will have the following actions preformed on it:
#
#	1) Setup for conversion to Text
#	2) Conversion to Text using 3rd party software (XIS ScanWorX)
#	3) Attempt to identify possible recipients using Jae Chung's
#	   faxroute software
#	4) If attempt in #3 is successful, use "forwardfax" to forward
#	   the fax to the user. 
#
#

#
# Site Dependent Paths and Options

XPRESSFAX_HOME=/usr/xpressfax
XPRESSFAX_FAXRC=/usr/xpressfax/.faxrc
XIS_ICRCL_BINARY=/home/xpressware/xis/Icrf/bin/icrcl
TEMP_DIR=$XPRESSFAX_HOME/tmp
OUTPUT=$TEMP_DIR/autoroute.$$

#
# Insure that environment variables are set properly and the like
#
#
PATH=$PATH:$XPRESSFAX_HOME/utils
export PATH XPRESSFAX_HOME


FOUND_A_FORWARD=0

# 
# Create a temporary directory and "split" the fax image into seperate
# files, one per page, in that directory.   This is done mostly because
# the XIS ScanWorX software can only read one page (directory) TIFF files
#
/bin/rm -rf $OUTPUT
/bin/mkdir $OUTPUT
$XPRESSFAX_HOME/bin/tiffsplit $1 $OUTPUT/fax

if [ -f $OUTPUT/faxaa.tif ]; then
	echo ""
else
	exit -1
fi

#
# Use XIS ScanWorX to convert first page to text
#
$XIS_ICRCL_BINARY -o $OUTPUT/output -w -r $OUTPUT/faxaa.tif
if [ -f $OUTPUT/output.txt ]; then
	echo ""
else
	exit -2
fi

#
# Use the text file to try and find one or more forwardee's 
#
R=`$XPRESSFAX_HOME/utils/faxrouter -u $XPRESSFAX_HOME/data/forwardbook -i $OUTPUT/output.txt`

#
# If any were found forward the whole image to them.   You can comment in 
# the logging code here if you want a record of who got a copy of what...
#
if [ "$R" = "" ]; then
	echo 
else
	$XPRESSFAX_HOME/bin/forwardfax $R $1
	FOUND_A_FORWARD=1
#	echo "Forwarded $1 to $R " >> $FORWARD_LOG
fi

# 
# Cleanup  -- You can comment in the removal code here if forwarded faxes
# are assumed to have been forwarded correctly and you don't want to keep the
# orig document in the inbound spool directory.
#
/bin/rm -rf $OUTPUT
#if [ "$FOUND_A_FORWARD" = "1" ]; then
#  /bin/rm -rf $1
#fi
exit 0
