#! /bin/sh 
#
# Annoying shell script used for final installation and configuration of
# the XpressFax package.   If this script fails the important tasks it tries
# to do are listed below:
#
# 1)	Adds the following three lines to /etc/rc.local for a faxserver host:
#
#		if [ -f /usr/xpressfax/sbin/xpressfax_start_daemons ]; then
#			/usr/xpressfax/sbin/xpressfax_start_daemons
#		fi
#
# 2)	Creates /dev/cu0b if it does not exist, chowns to fax administrator:
#
#		mknod /dev/cu0b c 12 129
#		chown $FAX_LOGIN /dev/cu0b
#		chmod 700 /dev/cu0b
#
# 3)	Runs the install_lpd.sh and install_mail.sh scripts to install
#	aliases via mail and lpr to mail and print documents via XpressFax.
#	These scripts can be run anytime by root to setup aliases/lpd names.
#
# 4) 	Adds the defined administrator user (owner of the xpressfax_modem
#	program) to the list of registered faxusers stored in $XPRESSFAX_HOME/
#	data/forwardbook as: 00000<tab>english name<tab>username@host
#
# 5)	Runs 'faxlicense' to let the user license the software
#
#
# 6)	starts up the faxserver, faxmail and faxmodem daemons for the package
#	by running:
#
#		$XPRESSFAX_HOME/sbin/xpressfax_start_daemons.sh
#
#
#

if [ "$OPENWINHOME" = "" ]; then
	OPENWINHOME=/usr/openwin
fi

if [ "$XPRESSFAX_HOME" = "" ]; then
	XPRESSFAX_HOME=`dirname $0`/..
	if [ "$XPRESSFAX_HOME" = "./.." ]; then
		XPRESSFAX_HOME=`pwd`/..
	fi
fi

if [ "$XPRESSFAX_FAXRC" = "" ]; then
	XPRESSFAX_FAXRC=$XPRESSFAX_HOME/.faxrc
fi

if [ "$LD_LIBRARY_PATH" = "" ]; then
	LD_LIBRARY_PATH=$XPRESSFAX_HOME/lib:$OPENWINHOME/lib
else
	LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$XPRESSFAX_HOME/lib:$OPENWINHOME/lib
fi

export LD_LIBRARY_PATH XPRESSFAX_HOME XPRESSFAX_FAXRC
#
# Routine to ask a question with default passed and check for typos
# $?=1 for default response
# $1=question, $2=default, $3=opposite of $2
ask(){
        answer=undefined
        echo -n "$1 [$2]: "
        read answer
        until [ "$answer" = "" -o "$answer" = "$2" -o "$answer" = "$3" ];
        do
           echo "Please type '$2' or '$3'."
           echo -n "$1 [$2]: "
           read answer
        done
        [ "$answer" = "$2" -o "$answer" = "" ]
}

clear
if [ `whoami` != "root" ]; then
	echo "Sorry, only root may run this script."
	exit 1
fi


client_or_server_message(){
echo "
********************************************************************************
********************************************************************************
**                                                                            **
**                         XpressFax Version  1.0.5                           **
**                         Host Installation Script                           **
**                                                                            **
********************************************************************************
********************************************************************************

You are currently running this installation software on the host named:
"`hostname`"

This installation script must be told if this host to be an XpressFax client
or faxserver machine.   The faxserver machine is the one to which the faxmodem
or faxmodems are to be attached and will be the one to which the XpressFax
software is licensed.

"
}
installation_message(){
echo "
********************************************************************************
********************************************************************************
**                                                                            **
**                         XpressFax Version  1.0.5                           **
**                         Host Installation Script                           **
**                                                                            **
********************************************************************************
********************************************************************************

This installation script ($XPRESSFAX_HOME/install/install_xpressfax.sh) is 
designed to assist the system manager in the installation and system 
configuration of the XpressFax Package.   Both faxserver hosts as well as 
faxclient hosts may be configured to enable XpressFax usage with this 
installation script. 

"
}
server_message(){
echo "
********************************************************************************
********************************************************************************
**                                                                            **
**                         XpressFax Version  1.0.5                           **
**                         Host Installation Script                           **
**                                                                            **
********************************************************************************
********************************************************************************

XpressFax Server Installation:

"
}
client_message(){
echo "
********************************************************************************
********************************************************************************
**                                                                            **
**                         XpressFax Version  1.0.5                           **
**                         Host Installation Script                           **
**                                                                            **
********************************************************************************
********************************************************************************

XpressFax Client Installation:

"
}
#
# If the user is running yellow pages they must add the passwd entry by 
# hand or at least verify that xpressfax is a known user in the NIS database.
#
clear
cd $XPRESSFAX_HOME/install
installation_message
if ask "Would you like to continue with this installation process?" "y" "n"; then
	echo 0
else
	exit 0
fi

clear
client_or_server_message
if ask "Enter (c) for client machine (s) for server machine: " "s" "c"; then
	TYPE=server
else
	TYPE=client
fi

clear
if [ "$TYPE" = "client" ]; then
	client_message
	sh install_rc.local_client.sh
	if ask "Would you like me to start the faxmaild process now?" "y" "n"; then
		$XPRESSFAX_HOME/sbin/xpressfax_faxmaild 
	fi
	echo " Done with client installation process."
else
	server_message
	sh install_rc.local.sh
	/bin/rm -rf $XPRESSFAX_HOME/.default-server
	echo "server= "`hostname` >  $XPRESSFAX_HOME/.default-server
	chmod 644 $XPRESSFAX_HOME/.default-server

	if ask "Would you like to install a mail alias for faxes?" "y" "n"; then
	sh install_mail.sh notitle
	fi

	if ask "Would you like to install a printer path through lpd for faxes?" "y" "n"; then
	sh install_lpd.sh notitle
	fi

	echo " "
	if [ -f /dev/cu0b ]; then
		echo ""
	else
		echo "Creating /dev/cu0b with major device number 12, minor 129"
		/etc/mknod /dev/cu0b c 12 129
	fi
	if [ -f $XPRESSFAX_HOME/sbin/xpressfax_modem ]; then
FAX_LOGIN=`ls -lt $XPRESSFAX_HOME/sbin/xpressfax_modem | awk -F" " '{print $3}'`
	else
	echo -n "Enter login name of XpressFax Administrator Account: "
	read FAX_LOGIN
	echo " "
	fi
	DEVDONE=0
	until [ "$DEVDONE" = "1" ]; 
	do
		echo -n "Enter the name of the default modem device (/dev/cu0b): "
		read DEVNAME
		if [ "$DEVNAME" = "" ]; then
			DEVNAME=/dev/cu0b
		fi
		if [ -c $DEVNAME ]; then
				DEVDONE=1
			echo "Chowning $DEVNAME to $FAX_LOGIN & chmoding it for owner access only"
			/usr/etc/chown $FAX_LOGIN  $DEVNAME
			/usr/etc/chown -R $FAX_LOGIN $XPRESSFAX_HOME/filters
			/usr/bin/chmod 4755 $XPRESSFAX_HOME/filters/lpd_filter
			/usr/bin/chmod 4755 $XPRESSFAX_HOME/filters/mail_filter
			/usr/bin/chmod 4755 $XPRESSFAX_HOME/bin/faxlicense
			/usr/bin/chmod 4755 \
				$XPRESSFAX_HOME/sbin/xpressfax_faxmaild
			/usr/bin/chmod 4755 \
				$XPRESSFAX_HOME/sbin/xpressfax_serverd
			/usr/bin/chmod 700 $DEVNAME
			echo "modem1	Any	Idle	-1	818 555 1212	Date String	$DEVNAME	1	1			" > $XPRESSFAX_HOME/data/faxdevices
		fi
	done
#
# Clear out user book and install default faxuser
#
	/bin/cp /dev/null $XPRESSFAX_HOME/data/forwardbook
	echo "00000	$FAX_LOGIN	$FAX_LOGIN@`hostname`" > $XPRESSFAX_HOME/data/forwardbook
	if ask "Would you like to license the XpressFax Package now?" "y" "n"; then
		if [ "$DISPLAY" = "" ]; then
			DONEDPY=0
        	until [ "$DONEDPY" = "1" ]; 
			do
				echo -n "Please enter the X display name you'd like to use: "
				read DISPLAY
				if [ "$DISPLAY" = "" ]; then
					DONEDPY=0
				else
					DONEDPY=1
				fi
			done
		fi
		DISPLAY=$DISPLAY
		export DISPLAY
		$XPRESSFAX_HOME/bin/faxlicense
		status=$?
   		if [ "$status" != "0" ]; then
			echo "
Trouble running $XPRESSFAX_HOME/bin/faxlicense.  You will have to run this
license software by hand.   Make sure you are logged into the fax
administrator account or as root and are running the X11 window system 
[OpenWindows] when running the faxlicense module.
"
			echo -n "Hit <return> to continue. "
			read BLAH
		fi
	else
		LIC=`$XPRESSFAX_HOME/bin/show_license | grep Unlic | wc -l`
		if [ "$LIC" -eq "0" ]; then
			echo "

Very well, I will not run faxlicense at this time.   Note that the XpressFax
software must be licensed before it will begin to function.   To license the
software at a later date you will need to be logged into the fax
administrators account or to the root account and will need to run 
$XPRESSFAX_HOME/bin/faxlicense.   See the installation manual
for more details.

You should logout and log back in as the fax administrator  to work with the 
XpressFax Package.

"
			echo -n "Hit <return> to continue. "
			read BLAH
		else
			echo "
Very well, but I see that the package has already been licensed on this host.
"
		fi
	fi
	echo " "
	if ask "Would you like me to start the daemon and modem processes now?" "y" "n"; then
		$XPRESSFAX_HOME/sbin/xpressfax_start_daemons
	fi
fi
echo "

                                  Installation complete.   

 **  LOGOUT AND LOG BACK IN AS '$FAX_LOGIN' TO BEGIN WORKING WITH XPRESSFAX  **

"
exit 0
