/* File: toggle_button.h
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * ToggleButton
 */

#ifndef ToggleButton_h
#define ToggleButton_h

// Section: Description
//   This class provides an button with two (2) states and two (2)
//   corresponding actions.  The state may be changed from chosen to
//   unchosen or vice versa by software (use of chosen(boolean)) without
//   triggering an action.  If the state is changed by a mouse button hit
//   an action is triggered.  The select action is used if the button
//   becomes chosen and the deselect action is used if the button becomes
//   unchosen.
//
//   Initiation of actions and on-screen behaviour is inhibited if the
//   button is disabled.

#include <UI/generic_button.h>

class ToggleButton: public GenericButton
{
public:
    ToggleButton(Telltale* t, Action* select =nil, Action* deselect =nil,
        boolean* value = nil);
    ~ToggleButton();
    virtual void commit(Event& anEvent);

    virtual void deselect_action(Action* action) { _deselect_action = action; }
    virtual Action* deselect_action() const { return(_deselect_action); }

private:
    Action* _deselect_action;
    boolean* _value;
};

#endif
