/* File: generic_button.h
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GenericButton
 */

#ifndef generic_button_h
#define generic_button_h

// Section: Description
//   This class is modelled on the InterViews Button class.  It
//   is intended as a replacement for that class.  It supports
//   extra functionality including button choosing and enabling.
//   It is designed to be used as a virtual base class for buttons
//   with even more features such as toggle buttons and radio buttons.
//
//   The telltale is a glyph-based object that can have multiple looks
//   depending upon its state.  The button doesn't care about the look
//   it simply manipulates the state of the telltale to match the calls
//   to button methods.  It can enable or disable it, choose or unchoose
//   it, and highLight or unhighlight it.  The telltale chooses the
//   appropriate look based on the combination of these booleans.
//
//   Initiation of actions and on-screen behaviour is inhibited if the
//   button is disabled.

#include <InterViews/ptrhandler.h>
#include <InterViews/monoglyph.h>

class ivAction;
class ivListener;
class ivTelltale;

class GenericButton : public MonoGlyph, public PointerHandler
{
public:
    GenericButton(Telltale* t, Action* select =nil);
    virtual ~GenericButton();

    virtual void drag(Event& anEvent);
    virtual void release(Event& anEvent);
    virtual void commit(Event& anEvent);
    virtual void choose(boolean state);
    virtual void enable(boolean state);
    boolean chosen() const;
    boolean enabled() const;

    void select_action(Action* action) { _select_action = action; }
    Action* select_action() const { return(_select_action); }

protected:
    Listener* listener() const;
    Telltale* telltale() const;

private:
    Action* _select_action;
    Listener* _listener;
    Telltale* _telltale;
    boolean _enabled;
    boolean _chosen;
};

// Function:
//   Indicate whether button has been chosen or not.

inline boolean GenericButton::chosen() const
{ return _chosen; }

// Function:
//   Indicate whether button has been enabled or not.

inline boolean GenericButton::enabled() const
{ return _enabled; }

// Protected Function:
//   Return pointer to attached listener (which is not nil).

inline Listener* GenericButton::listener() const
{ return _listener; }

// Protected Function:
//   Return pointer to attached telltale (or nil if it doesn't exist).

inline Telltale* GenericButton::telltale() const
{ return _telltale; }

#endif /* GenericButton_h */
