/* File: diamond_beveller.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

// Description:
//   This routine is used to draw a motif-like radio button.
//   It does so by drawing a diamond shape on a canvas using a medium color.
//   It then adds a light colored peak ('A') and a dark colored 'V' to the 
//   diamond to give is a pseudo-3D effect (a la motif radio button).
//   This makes it look like a small diamond that is 'raised up' from the 
//   surface of the screen.
//
// Hints:
//   By reversing the light and dark colors you can get the effect that 
//   the diamond is 'pressed in'.

#include "diamond_beveller.h"

#include <InterViews/canvas.h>
#include <InterViews/color.h>
#include <InterViews/margin.h>

#include <math.h>

void diamond(
    Canvas* canvas, const Color* light, const Color* medium, const Color* dark, Coord thickness,
    Coord left, Coord bottom, Coord right, Coord top)
{
    // determine the center of the diamond
    Coord center_x = (left + right) / 2;
    Coord center_y = (bottom + top) / 2;

    // determine other parameters   (are these used?)
    float slope = (top - bottom) / (right - left);
    float delta_x = thickness / sqrt(slope * slope + 1);
    float delta_y = slope * delta_x;

    // draw the exterior diamond shape using the medium color
    //     /\
    //    /  \
    //   /    \
    //  /      \
    //  \      /
    //   \    /
    //    \  /
    //     \/
    canvas->new_path();
    canvas->move_to(left, center_y);
    canvas->line_to(center_x, top);
    canvas->line_to(right, center_y);
    canvas->line_to(center_x, bottom);
    canvas->close_path();
    canvas->fill(medium);

    // overlay the bottom half of the diamond outline in 'shadow' (dark) color
    //  __    __
    //  \ \  / /
    //   \ \/ /
    //    \  /
    //     \/
    canvas->new_path();
    canvas->move_to(left, center_y);
    canvas->line_to(left + thickness, center_y);
    canvas->line_to(center_x, bottom + thickness);
    canvas->line_to(right - thickness, center_y);
    canvas->line_to(right, center_y);
    canvas->line_to(center_x, bottom);
    canvas->close_path();
    canvas->fill(dark);

    // overlay the top half of the diamond outline in 'light' color
    //     /\
    //    /  \
    //   / /\ \
    //  /_/  \_\
    canvas->new_path();
    canvas->move_to(left, center_y);
    canvas->line_to(left + thickness, center_y);
    canvas->line_to(center_x, top - thickness);
    canvas->line_to(right - thickness, center_y);
    canvas->line_to(right, center_y);
    canvas->line_to(center_x, top);
    canvas->close_path();
    canvas->fill(light);
}
