
#include <InterViews/action.h>
#include <InterViews/background.h>
#include <InterViews/bitmap.h>
#include <InterViews/border.h>
#include <InterViews/box.h>
#include <InterViews/center.h>
#include <InterViews/color.h>
#include <InterViews/glue.h>
#include <InterViews/margin.h>
#include <InterViews/session.h>
#include <InterViews/stencil.h>
#include <InterViews/style.h>
#include <InterViews/window.h>

#include <IV-look/bevel.h>
#include <IV-look/button.h>
#include <IV-look/choice.h>
#include <IV-look/kit.h>
#include <IV-look/menu.h>

#include "generic_button.h"
#include "radio_button.h"
#include "rbbox.h"
#include "toggle_button.h"
#include "wrapbox.h"
#include "initialspan.h"
#include "kit.h"
#include "string_chooser.h"

#include <iostream.h>
#include <stream.h>

class testClass {
public:
    testClass();
    ~testClass();
    void saveButton(GenericButton* g);
    void saveBox(RBBox* r);
    void toggleUp();
    void toggleDown();
    void disableToggle();
    void disableBox();
    void status();
private:
    GenericButton* _button;
    boolean _buttonEnable;
    boolean _boxEnable;
    RBBox* _box;
};

declare(ActionCallback,testClass)
implement(ActionCallback,testClass)


testClass::testClass() {
    _buttonEnable = true;
    _boxEnable = true;
}

testClass::~testClass() {

}

void testClass::saveButton(GenericButton* g) {
    _button = g;
}

void testClass::saveBox(RBBox* r) {
    _box = r;
}

void testClass::toggleDown() {
//    cout << "Toggle Button is in!" << endl;
}

void testClass::toggleUp() {
//    cout << "Toggle Button is out!" << endl;
}

void testClass::disableToggle() {
    _buttonEnable = !_buttonEnable;
    _button->enable(_buttonEnable);
}

void testClass::disableBox() {
    _boxEnable = !_boxEnable;
    _box->enable(_boxEnable);
}


int main(int argc, char** argv) {
    Session* session = new Session("demo", argc, argv);
    Style* style = session->style();
    Kit* kit = Kit::instance();
    GemsKit* gemsKit = GemsKit::instance();

    Glyph* vspace = new VGlue(20.0);
    Glyph* hspace = new HGlue(10.0);

    testClass* tester = new testClass();

    Menu* fileMenu = kit->pulldown(style);
    fileMenu->add_item(
        kit->simple_menu_item("Disable Toggle", style), 
        new ActionCallback(testClass) (tester,&testClass::disableToggle),
    );
    fileMenu->add_item(kit->menu_item_separator(style));
    fileMenu->add_item(kit->simple_menu_item("Quit", style), kit->quit());

    Menu* menuBar = kit->menubar(style);
    menuBar->add_item(kit->simple_menubar_item("File", style), fileMenu);

    LRWrapBox* wrapper = new LRWrapBox((Coord) 120.0);
    RBBox* rBox = new RBBox(wrapper);
    rBox->append(gemsKit->radio_button("1200", style, nil));
    rBox->append(gemsKit->radio_button("2400", style, nil));
    rBox->append(gemsKit->radio_button("4800", style, nil));
    rBox->append(gemsKit->radio_button("9600", style, nil));
    rBox->append(gemsKit->radio_button(kit->label("F", style), style, nil));

    wrapper->repair();
    rBox->choose(3);
    tester->saveBox(rBox);
    rBox->enable(2, false);

    // read the bitmap data file into a new bitmap object
    Bitmap* color1Bitmap = Bitmap::open("control.image");

    if (color1Bitmap == nil) {
	cout << " File: control.image   --> problems" << endl;
    }

    GenericButton* toggle = gemsKit->toggle_button(
        new Stencil(color1Bitmap, style->foreground()), style, 
        new ActionCallback(testClass) (tester,&testClass::toggleDown),
        new ActionCallback(testClass) (tester, &testClass::toggleUp)
    );
    tester->saveButton(toggle);

    GenericButton* disabler = gemsKit->push_button(
        "Flatten Them!", style,
        new ActionCallback(testClass) (tester, &testClass::disableBox)
    );

    GenericButton* status = gemsKit->push_button(
        "Status", style,
        new ActionCallback(testClass) (tester, &testClass::status)
    );

/*	new InitialSpan(
	    new InitialSpan(
		new TBBox(
		  menuBar,
		  kit->label("Radio Buttons", style),
		  new VGlue(5.0, 100.0, 0.0),
		),
		Dimension_X, 500.0),
	    Dimension_Y, 500.0), */

/*    StringChooser* streets = new StringChooser("Foo", style);
    Glyph* dialog =
       new Background(
	   new TBBox(
	       new VGlue(0.0, 0.0, 0.0),
       	       gemsKit->toggle_button(
       	       	   style, 
       	       	   nil, nil,
       	       	   nil, kit->label("Chemical", style)
       	       ),
       	       streets->chooser(),
	       streets->editor()
	   ),
	   style->flat()
       );
  */    	
     Glyph* dialog = new Background(

	 new TBBox(  
            new LRBox(hspace, rBox, hspace),
	    new Margin(kit->label("Toggle Button", style), 15.0),
            new LRBox(hspace, toggle, hspace),
	    new Margin(kit->label("Disable Radio Buttons", style), 15.0),
            new LRBox(hspace, disabler, hspace),
            new LRBox(hspace, status, hspace),
            vspace  
	),

	style->flat()
    );



    Window* w = new ApplicationWindow(dialog);

    session->run_window(w);

    delete tester;
    delete w;
    delete session;
    return 0;
}

void testClass::status()
{
    cout << "Button Status Report" << endl;
    cout << "\nchosen radio button index: " << _box->chosen()
         << "\n" << endl;

    cout << "radio button 1: " 
         << (_box->enabled(1) ? "enabled" : "disabled")
         << endl;

    cout << "radio button 2: " 
         << (_box->enabled(2) ? "enabled" : "disabled")
         << endl;

    cout << "radio button 3: " 
         << (_box->enabled(3) ? "enabled" : "disabled")
         << endl;

    cout << "radio button 4: " 
         << (_box->enabled(4) ? "enabled" : "disabled")
         << "\n" << endl;

    cout << "toggle button: " 
         << (_button->enabled() ? "enabled" : "disabled")
         << endl;

    cout << "toggle button state: " 
	 << (_button->chosen() ? "true" : "false") 
         << "\n" << endl;
}
