#include <InterViews/action.h>
#include <InterViews/box.h>
#include <InterViews/glue.h>

#include <IV-look/field.h>

#include <stdio.h>
#include <stdlib.h>
//#include <math.h>

#include "date_editor.h"

declare(ActionCallback, DateEditor);
implement(ActionCallback, DateEditor);

DateEditor::DateEditor(int month, int day, int year, Style* style, Action* action)
{
  _action = action;

  _month_editor = new FieldEditor(
       "  ", style, new ActionCallback(DateEditor)(this, &DateEditor::date_cb));
  
  _day_editor = new FieldEditor(
       "  ", style, new ActionCallback(DateEditor)(this, &DateEditor::date_cb));

  _year_editor = new FieldEditor(
       "    ", style, new ActionCallback(DateEditor)(this, &DateEditor::date_cb));
  
  Glue* fixed_hsep = new VGlue(2.0, 0.0, 0.0);

  body(
       new LRBox(
       	   new HGlue(0.0, 50.0, 0.0),
       	   new LRBox(
       	       _month_editor,
       	       fixed_hsep,
       	       _day_editor,
       	       fixed_hsep,
       	       _year_editor,
       	       fixed_hsep
       	   )
       )
   );

  DateEditor::month(month);
  DateEditor::day(day);
  DateEditor::year(year);
}

DateEditor::~DateEditor() { }

int DateEditor::month()
{ 
  return(atoi(_month_editor->text()));
}

int DateEditor::day()
{
  return(atoi(_day_editor->text()));
}

int DateEditor::year()
{
  return(atoi(_year_editor->text()));
}

void DateEditor::month(int v)
{ 
  static char buf[50];
  sprintf(buf, "%d\n", v);
  _month_editor->field(buf);
}

void DateEditor::day(int v)
{
  static char buf[50];
  sprintf(buf, "%d\n", v);
  _day_editor->field(buf);
}

void DateEditor::year(int v)
{
  static char buf[50];
  sprintf(buf, "%d\n", v);
  _year_editor->field(buf);
}

void DateEditor::date_cb()
{
  if (_action) (_action->execute());
}
