

#include <InterViews/border.h>
#include <InterViews/box.h>
#include <InterViews/center.h>
#include <InterViews/event.h>
#include <InterViews/font.h>
#include <InterViews/label.h>
#include <InterViews/listener.h>
#include <InterViews/sensor.h>
#include <InterViews/target.h>
#include <InterViews/transformer.h>
#include <InterViews/tformsetter.h>
#include <InterViews/margin.h>
#include <InterViews/patch.h>
#include <InterViews/window.h>
#include <InterViews/world.h>

#include <IV-look/telltale.h>
#include <stream.h>

#include "viewer.h"

declare(ActionCallback,Zoomer);
implement(ActionCallback,Zoomer);

Zoomer::Zoomer(
    Telltale* t, Adjustable* a, float zoom
) : Button(new ActionCallback(Zoomer)(this, &Zoomer::zoom), t), Adjuster(a) {
    _zoom = zoom;
}

Zoomer::~Zoomer () { }

void Zoomer::zoom () {
    subject()->zoom_to(_zoom);
}

Viewer::Viewer (Glyph* view) : MonoGlyph(nil), Handler(), Adjustable() {
    _zoom_x = 1.0;
    _zoom_y = 1.0;
    for (int i = 0; i < Dimension_Undefined; ++i) {
        _current[i] = 0;
    }
    _view = view;
    if (_view != nil) {
        _view->ref();
    Requisition r;
    _view->request(r);
    x = r.requirement(Dimension_X).natural();
    y = r.requirement(Dimension_Y).natural();
    }
    _patch = new Patch(_view);
    body(_patch);
}

Viewer::~Viewer () {
    if (_view != nil) {
        _view->unref();
    }
}

void Viewer::scroll_and_zoom_to(Coord pct_over, Coord pct_up, Coord pct_wide,
				Coord pct_high)
{
  _zoom_x = cur_length(Dimension_X) / (x * pct_wide);
  _zoom_y = cur_length(Dimension_Y) / (y * pct_high);
  _current[Dimension_X] = - x * pct_over * _zoom_x;
  _current[Dimension_Y] = - y * pct_up * _zoom_y;
  notify();
}

void Viewer::allocate(Canvas* c, const Allocation& a, Extension& e)
{
 MonoGlyph::allocate(c,a,e);
 _zoom_x = cur_length(Dimension_X) / x;
 _zoom_y = cur_length(Dimension_Y) / y;
 notify();
}
/*
void Viewer::request(Requisition& r) const
{
 MonoGlyph::request(r);
  Requirement& r_x = r.requirement(Dimension_X);
  Requirement& r_y = r.requirement(Dimension_Y);
//  printf("before\n");
//  printf("X's stretch= %f shrink= %f natural= %f align= %f\n", r_x.stretch(),
//	 r_x.shrink(), r_x.natural(), r_x.alignment());
//  printf("Y's stretch= %f shrink= %f natural= %f align= %ff\n", r_y.stretch(),
//	 r_y.shrink(), r_y.natural(), r_y.alignment());
  r_x.stretch(fil);
  r_x.shrink(fil);
  r_y.stretch(fil);
  r_y.shrink(fil);
//  r.require(Dimension_X, r_x);
//  r.require(Dimension_Y, r_y);
  r_x = r.requirement(Dimension_X);
  r_y = r.requirement(Dimension_Y);
//  printf("after\n");
//  printf("X's stretch= %f shrink= %f natural= %f align= %ff\n", r_x.stretch(),
//	 r_x.shrink(), r_x.natural(), r_x.alignment());
//  printf("Y's stretch= %f shrink= %f natural= %f align= %ff\n", r_y.stretch(),
//	 r_y.shrink(), r_y.natural(), r_y.alignment());
}
*/

void Viewer::draw(Canvas* c, const Allocation& a) const {
  c->push_clipping();
  c->clip_rect(a.left(), a.bottom(), a.right(), a.top());
 MonoGlyph::draw(c,a);
  c->pop_clipping();
}

Coord Viewer::lower(DimensionName d) {
//    Allotment& a = _patch->allocation().allotment(d);
    return _patch->allocation().allotment(d).origin() + 
      _current[d] - length(d) * _patch->allocation().allotment(d).alignment();
}

Coord Viewer::upper(DimensionName d) {
//    Allotment& a = _patch->allocation().allotment(d);
    return _patch->allocation().allotment(d).origin() + 
      _current[d] + length(d) * 
	(1-_patch->allocation().allotment(d).alignment());
}

Coord Viewer::length(DimensionName d) {
    if (d == Dimension_X)
        return x * _zoom_x;
    if (d == Dimension_Y)
        return y * _zoom_y;
}

Coord Viewer::cur_lower(DimensionName d) {
    return _patch->allocation().allotment(d).begin();
}
    
Coord Viewer::cur_upper(DimensionName d) {
    return _patch->allocation().allotment(d).end();
}
    
Coord Viewer::cur_length(DimensionName d) {
    return _patch->allocation().allotment(d).span();
}

void Viewer::notify() {
    _patch->redraw();
    Transformer tx;
    tx.scale(_zoom_x, _zoom_y);
    tx.translate(_current[Dimension_X], _current[Dimension_Y]);
    _patch->body(new TransformSetter(_view, tx));
    _patch->reallocate();
    _patch->redraw();
    Adjustable::notify();
}

void Viewer::scroll_forward(DimensionName d) {
    _current[d] += 1;
    notify();
}

void Viewer::scroll_backward(DimensionName d) {
    _current[d] -= 1;
    notify();
}

// Not really PAGING forward, so this should
//  be modified for each specific application

void Viewer::page_forward(DimensionName d) {
    _current[d] += 10;
    notify();
}

void Viewer::page_backward(DimensionName d) {
    _current[d] -= 10;
    notify();
}

void Viewer::scroll_to(DimensionName d, Coord p) {
    _current[d] = p;
    notify();
}

void Viewer::zoom_to (float x_zoom, float y_zoom) {
    _zoom_x *= x_zoom;
    _zoom_y *= y_zoom;
    notify();
}

// Not in Adjustable's protocol
void Viewer::zoom_to_fit (Coord x_dim, Coord y_dim) {
    _zoom_x = x_dim / x;
    _zoom_y = y_dim / y;
    notify();
}

void Viewer::event (Event& e) {
    if (e.type() == Event::down) {
        Coord x = _current[Dimension_X] - e.pointer_x();
        Coord y = _current[Dimension_Y] - e.pointer_y();
        do {
            _current[Dimension_X] =  x + e.pointer_x();
            _current[Dimension_Y] =  y + e.pointer_y();
            notify();
            e.read();
        } while (e.type() != Event::up);
    } else if (e.type() == Event::key) {
        if (e.keycode() == 61){
//            e.world()->quit();
        }
    }
}


