/* File: test_bed.h
 * Created: 4/27/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#ifndef test_bed_h
#define test_bed_h

#include <InterViews/glyph.h>
#include <InterViews/patch.h>
#include <IV-look/adjustable.h>
#include <IV-look/adjuster.h>
#include <IV-look/button.h>

class TestBed : public Patch, public Adjustable {
public:
  TestBed(
       Glyph* =nil, Glyph* =nil, Glyph* =nil, Glyph* =nil, Glyph* =nil, 
       Glyph* =nil, Glyph* =nil, Glyph* =nil, Glyph* =nil, Glyph* =nil
   );

  ~TestBed();
  
  virtual void append(Glyph* glyph);
  virtual void remove(GlyphIndex);
  Glyph* adjuster() { return(_adjuster); }

 virtual void scroll_forward(DimensionName =Dimension_X);
 virtual void scroll_backward(DimensionName =Dimension_X);
 
 virtual Coord lower(DimensionName) const { return(0.0); }
 virtual Coord upper(DimensionName) const { return(0.0); }
 virtual Coord length(DimensionName) const { return(0.0); }
 virtual Coord cur_lower(DimensionName) const { return(0.0); }
 virtual Coord cur_upper(DimensionName) const { return(0.0); }
 virtual Coord cur_length(DimensionName) const { return(0.0); }
 
private:
  void update_display();
  void use(GlyphIndex index);

  class Deck* _deck;
  class FieldEditor* _display;
  Glyph* _adjuster; 
};


#endif
