/*
 * ParticleTracker
 */

#include <IV-look/button.h>
#include <IV-look/kit.h>
#include <InterViews/background.h>
#include <InterViews/transformer.h>
#include <InterViews/box.h>
#include <InterViews/center.h>
#include <InterViews/display.h>
#include <InterViews/glue.h>
#include <InterViews/bitmap.h>
#include <InterViews/color.h>
#include <InterViews/label.h>
#include <InterViews/margin.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/action.h>
#include <InterViews/stencil.h>
#include <InterViews/canvas.h>
#include <InterViews/deck.h>
#include <InterViews/border.h>
#include <InterViews/patch.h>
#include <InterViews/page.h>
#include <InterViews/brush.h>
#include <InterViews/shapeof.h>
#include <InterViews/event.h>
#include <InterViews/hit.h>
#include <InterViews/listener.h>

#include <OS/string.h>
#include <stream.h>
#include <math.h>

#include "figure.h"
#include "particle_tracker.h"

ParticleTracker::ParticleTracker(
       SimulationController* controller, DrawingBox* box)
   : DrawingSimulation(controller, box)
{
  button(true, Event::left);

  // _release_counter counts the number of seconds since the last particle release
  // from the sources.
  // _release_step is the number of seconds between particle releases.
  // _release_height is the height that new particle source release particles at.
  _release_counter = 0;
  _release_step = 70;
  _release_height = 0.0;

  _move_step = 5.0;
  _shape = point;

  // Give the drawing box of the particle tracker the same structure as the
  // box that contains the particle tracker.  
  // The particle tracker drawing box is appended into the particle tracker
  // drawing.
  append(_particle_tracker = new DrawingBox(box->structure()));
  
  _particle_tracker->append(
       _source_drawing = new Drawing(_particle_tracker)
   );

  _particle_tracker->append(
       _particle_drawing = new Drawing(_particle_tracker)
   );

  RealCoord bottom = 10.0;
  RealCoord top = 1000.0;
  RealCoord left = 10.0;
  RealCoord right = 1000.0;
  RealCoord floor = 0.0;
  RealCoord ceiling = 1000.0;
  
  _source_drawing->append(
       _source_animation = new ParticleAnimation(
       	   box->structure(), top, bottom, left, right, floor, ceiling
       )
   );

  _particle_drawing->append(
       _particle_animation = new ParticleAnimation(
       	   box->structure(), top, bottom, left, right, floor, ceiling
       )
   );
}

ParticleTracker::~ParticleTracker()
{
}

void ParticleTracker::update()
{
//  printf("ParticleTracker::update()\n");

  if (time_expired())
    _time_counter = _time_start;

//  printf("\trelease_counter=%d release_step=%d\n", _release_counter, _release_step);

  ++_release_counter;  
  if ((_release_step != 0) && (_release_counter >= _release_step)) {
    _release_counter = 0;
//    printf("release particles\n");
    release_particles();
  }

//  printf("\tmove particles\n");
  move_particles();

  DynamicSimulation::update();
}

void ParticleTracker::move_particles()
{
  RealCoord x, y, z;

  for (Particle* particle = head() ; particle ; particle = particle->next() ) {
    particle->real_location(x, y, z);

//    x += 1.0;
//    y = y + 50.0 *sin(x);

    x += 10.0;
    y += 10.0;
    z += 1.0;

/*    float f = atan2(y -500.0, x -500.0);
    f += M_PI/2.0;
    if (f > M_PI) f -= 2.0*M_PI;
    y += 10.0 * sin(f); 
    x += 10.0 * cos(f);
    z += 1.0;
*/

    printf("ParticleTracker::move_particles()\n");
    printf("\t x=%f, y=%f, z=%f\n\n",x,y,z);
    
    particle->move(_move_step, x, y, z);
  }
}

void  ParticleTracker::release_particles()
{
  ScreenCoord x, y, z;
  Particle* source = _source_animation->head();
  
//  printf("ParticleTracker::release_particles()\n");

  for ( ; source ; source = source->next() ) {
    source->screen_location(x, y, z);
//    printf("\tScreen x=%f y=%f z=%f\n", x, y, z);
    add_particle(x, y, z);
  }
}

void ParticleTracker::add_source(ScreenCoord x, ScreenCoord y, ScreenCoord z)
{
//  printf("ParticleTracker::add_source()\n");
//  printf("\tScreen x=%f y=%f z=%f\n", x, y, z);
  _source_animation->allocate(new ParticleSource(_source_animation, x, y, z));
}

void ParticleTracker::press(Event& e)
{
//  printf("ParticleTracker::press()\n");
//  printf("\t x=%f y=%f\n", e.pointer_x(), e.pointer_y());

  add_source(e.pointer_x(), e.pointer_y(), _release_height);
}

void ParticleTracker::add_particle(ScreenCoord x, ScreenCoord y, ScreenCoord z)
{
//  printf("ParticleTracker::add_particle()\n");
//  printf("\tScreen x=%f y=%f z=%f\n", x, y, z);

  Particle* p;

  switch (_shape) {

  case point:
    p = new ParticlePoint(_particle_animation, x, y, z);
    break;
   
  default:
    fprintf(stderr, "ParticleTracker::add_particle()\n");
    fprintf(stderr, "\tunknown shape\n");
//    ::abort();
  }

  _particle_animation->allocate(p);
}

void ParticleTracker::sources_visible(boolean b)
{
    _particle_tracker->visible(_source_drawing, b);
}

void ParticleTracker::clear_sources()
{
  _source_animation->remove();
  _source_animation->reallocate();
}

void ParticleTracker::clear_particles()
{
  _particle_animation->remove();
  _particle_animation->reallocate();
}

void ParticleTracker::start()
{
  DrawingSimulation::start();
  release_particles();
}

void ParticleTracker::stop()
{
   DrawingSimulation::stop();
   clear_particles();
   clear_sources();
}

void ParticleTracker::update_real_size(
       Coord top, Coord bottom, Coord left, Coord right, Coord floor, Coord ceiling)
{
//  printf("ParticleTracker::update_real_size()\n");
//  printf("\ttop=%f bottom=%f right=%f left=%f floor=%f ceiling=%f\n", top, bottom, right, left, floor, ceiling);

  _particle_animation->update_real_size(top, bottom, left, right, floor, ceiling);
  _source_animation->update_real_size(top, bottom, left, right, floor, ceiling);
}
