/*
 * Drawing
 */

#ifndef drawing_h
#define drawing_h

#include <InterViews/ptrhandler.h>
#include <InterViews/monoglyph.h>
#include <InterViews/event.h>
#include <InterViews/patch.h>

class ivAction;
class ivListener;
class Overlay;
class DrawingBox;

class Drawing : public MonoGlyph, public PointerHandler {
public:
  Drawing(DrawingBox*);
  ~Drawing();

  virtual void sensitive(boolean b);
  void current(boolean b =true);
  void visible(boolean b =true);

  virtual void button(boolean b, EventButton button =Event::any);
  virtual void motion(boolean b);
  virtual void key(boolean b);

  virtual void press(Event& eb);
 
protected:
  Listener* listener() const;
  
private:
  DrawingBox* _drawing_box;
  Listener* _listener;
  EventButton _button;
};

inline Listener* Drawing::listener() const { return(_listener); }

/*
 * DrawingBox
 */

class DrawingBox : public Patch {
public:
  DrawingBox(Coord height, Coord width);
  DrawingBox(Glyph* structure);
  ~DrawingBox();

  virtual void visible(Drawing* v, boolean b =true);
  virtual void current(Drawing* v, boolean b =true);
  Glyph* structure();
  
private:
  Glyph* _structure;
  virtual boolean contains(Glyph* g);
  long lookup(Glyph* g);

  Drawing* _current;
};

inline Glyph* DrawingBox::structure() { return(_structure); }

#endif
