/* File: rbbox.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * RBBox(RadioButtonBox)
 */

#include <InterViews/action.h>
#include <InterViews/box.h>
#include <InterViews/center.h>
#include <InterViews/fixedspan.h>
#include <InterViews/margin.h>
#include <OS/list.h>

#include "rbbox.h"
#include "kit.h"
     
#include <stream.h>
     
class ButtonRef : public Action {
public:
  ButtonRef(GenericButton* button, Action* select_action, RBBox* box);
  ~ButtonRef();

  void execute();

  RBBox* _box;
  GenericButton* _button;
  Action* _select_action;
};
  
declareList(ButtonRef_List,ButtonRef*);
implementList(ButtonRef_List,ButtonRef*);

RBBox::RBBox(
    	Glyph* context, Style* style, Action* action,
    	Glyph* b1, Glyph* b2,
    	Glyph* b3, Glyph* b4,
    	Glyph* b5, Glyph* b6,
    	Glyph* b7, Glyph* b8,
    	Glyph* b9, Glyph* b10
    ) : MonoGlyph(context)
{
  _buttons = new ButtonRef_List(11);
  _chosen_button = 0;
  _multiple_selections = false;
  
  /*
   * Put a nil button into the list of box elements so
   * RBBox::choose(nil) will unchose every button in the
   * RBBox.
   */
  ButtonRef* button_ref = new ButtonRef(nil, nil, this);
  Resource::ref(button_ref);
  _buttons->append(button_ref);

  if (b1) append(b1, style, action);
  if (b2) append(b2, style, action);
  if (b3) append(b3, style, action);
  if (b4) append(b4, style, action);
  if (b5) append(b5, style, action);
  if (b6) append(b6, style, action);
  if (b7) append(b7, style, action);
  if (b8) append(b8, style, action);
  if (b9) append(b9, style, action);
  if (b10) append(b10, style, action);
}

RBBox::RBBox(
    	Glyph* context,
    	GenericButton* b1, GenericButton* b2,
    	GenericButton* b3, GenericButton* b4,
    	GenericButton* b5, GenericButton* b6,
    	GenericButton* b7, GenericButton* b8,
    	GenericButton* b9, GenericButton* b10
    ) : MonoGlyph(context)
{
  _buttons = new ButtonRef_List(11);
  _chosen_button = 0;
  _multiple_selections = false;
  
  /*
   * Put a nil button into the list of box elements so
   * RBBox::choose(nil) will unchose every button in the
   * RBBox.
   */
  ButtonRef* button_ref = new ButtonRef(nil, nil, this);
  Resource::ref(button_ref);
  _buttons->append(button_ref);

  if (b1) append(b1);
  if (b2) append(b2);
  if (b3) append(b3);
  if (b4) append(b4);
  if (b5) append(b5);
  if (b6) append(b6);
  if (b7) append(b7);
  if (b8) append(b8);
  if (b9) append(b9);
  if (b10) append(b10);
}

RBBox::RBBox(Glyph* context, GlyphIndex size)
    : MonoGlyph(context)
{
  _buttons = new ButtonRef_List(size+1);
  _chosen_button = 0;
  _multiple_selections = false;

  /*
   * Put a nil button into the list of box elements so
   * RBBox::choose(nil) will unchose every button in the
   * RBBox.
   */
  ButtonRef* button_ref = new ButtonRef(nil, nil, this);
  Resource::ref(button_ref);
  _buttons->append(button_ref);
}

RBBox::~RBBox()
{
  for (ListItr(ButtonRef_List) i(*_buttons) ; i.more() ; i.next()) {
    ButtonRef* button_ref = i.cur();
    Resource::unref(button_ref);
  }
  delete _buttons;
}

GenericButton* RBBox::chosen_button()
{
  return(_buttons->item(_chosen_button)->_button);
}

void RBBox::choose(GlyphIndex button)
{
  choose(_buttons->item(button)->_button);
}

boolean RBBox::enabled(GlyphIndex button)
{
  return(_buttons->item(button)->_button->enabled());
}

void RBBox::enable(GlyphIndex button, boolean state)
{
  _buttons->item(button)->_button->enable(state);
}

void RBBox::enable(boolean state)
{
  for (ListItr(ButtonRef_List) i(*_buttons) ; i.more() ; i.next())
    if (i.cur()->_button)
      i.cur()->_button->enable(state);
}

Glyph* RBBox::append(Glyph* g, Style* s, Action* a)
{
//  printf("RBBox::append(Glyph*, Style*, Action*)\n");

  GemsKit* kit = GemsKit::instance();
  GenericButton* button = kit->radio_button(g, s, a);
  append(button);
  return(button);
}

void RBBox::append(Glyph* g)
{
//  printf("RBBox::append(Glyph*)\n");

  MonoGlyph::append(g);
}

Glyph* RBBox::append(GenericButton* button)
{
  ButtonRef* button_ref = new ButtonRef(button, button->select_action(), this);

//  printf("RBBox::append(GenericButton*)\n");

  Resource::ref(button_ref);
  button->select_action(button_ref);
  _buttons->append(button_ref);
  MonoGlyph::append(button);
  return(button);
}

//   This function provides the 'car radio button' functionality.
//   It is passed a pointer to the newly chosen button.  The routine 
//   loops through the list of existing buttons looking for a match.
//   When the chosen button is found the index is saved.  All other 
//   buttons are 'unchosen'.

void RBBox::choose(GenericButton* button)
{
  int count = 0;

//  printf("RBBox::choose()\n");

  for (ListItr(ButtonRef_List) i(*_buttons) ; i.more() ; ++count, i.next()) {
    GenericButton* curr = i.cur()->_button;

    if (curr == button) {
      _chosen_button = count;
      if ((button != nil) && (!button->chosen()))
	button->choose(true);
    } else if (curr && !_multiple_selections)
      curr->choose(false);
  }
}

GenericButton* RBBox::button(GlyphIndex index)
{
  return(_buttons->item(index)->_button);
}

ButtonRef::ButtonRef(GenericButton* button, Action* select_action, RBBox* box) : Action()
{
  Resource::ref(_button = button);
  Resource::ref(_select_action  = select_action);
  _box = box;
}

ButtonRef::~ButtonRef()
{
  Resource::unref(_button);
  Resource::unref(_select_action);
}

void ButtonRef::execute()
{
//  printf("ButtonRef::execute()\n");

  _box->choose(_button);
  if (_select_action)
    _select_action->execute();  
}
