/* File: gems_kit.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GemsKit -- object for creating common UI objects
 */

#include "mf_kit.h"
#include "mono_kit.h"

#include <InterViews/color.h>
#include <InterViews/session.h>
#include <InterViews/style.h>

class GemsKitImpl {
private:
    friend class GemsKit;

    static GemsKit* instance_;

    static GemsKit* make_kit();
};

GemsKit* GemsKitImpl::instance_;

GemsKit::GemsKit() { }
GemsKit::~GemsKit() { }

GemsKit* GemsKit::instance() {
    if (GemsKitImpl::instance_ == nil) {
	GemsKitImpl::instance_ = GemsKitImpl::make_kit();
    }
    return GemsKitImpl::instance_;
}

GemsKit* GemsKitImpl::make_kit() {
    Style* s = Session::instance()->style();
    if (s->value_is_on("monochrome") || s->value_is_on("Monochrome"))
	return new GemsMonoKit;

    const Color* c1 = new Color(0.0, 0.0, 0.0, 1.0);
    const Color* c2 = new Color(1.0, 1.0, 1.0, 1.0);
    const Color* c3 = new Color(0.5, 0.5, 0.5, 1.0);
    if (!c1->distinguished(c2) || !c2->distinguished(c3))
	return new GemsMonoKit;

    return new GemsMFKit;
}
