/* File: initialspan.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * InitialSpan - give component an initial natural size.
 */

#include "initialspan.h"

#include <stream.h>

InitialSpan::InitialSpan(
    Glyph* body, DimensionName dimension, Coord span
) : MonoGlyph(body)
{
    _dimension = dimension;
    _span = span;
}

InitialSpan::~InitialSpan() { }

/* 
 * InitialSpan::request()
 *
 */
void InitialSpan::request(Requisition& requisition) const
{
    MonoGlyph::request(requisition);

    Requirement& r = requisition.requirement(_dimension);

    Requirement nr(_span, r.stretch(), _span - r.natural() - r.shrink(), r.alignment());
    requisition.require(_dimension, nr);
}

