/*
 * ParticleTracker
 */

#include <math.h>
#include <stdio.h>

#include <AIRSHED/database.h>
#include <AIRSHED/return_value.h>
#include <AIRSHED/client.h>
#include <AIRSHED/day_record.h>

#include "gems.h"
#include "query_particle_tracker.h"

QueryParticleTracker::QueryParticleTracker(
       SimulationController* controller, DrawingBox* box)
   : ParticleTracker(controller, box)
{
}

QueryParticleTracker::~QueryParticleTracker() { }

void QueryParticleTracker::move_particles()
{
  RealCoord x, y, z;
  float *k1, *k2,*k3,*k4;
  float h;
  return_value *r_v1, *r_v2, *r_v3, *r_v4;
  int ts;
  ts = time_step();
  h = (float)ts/3600.0;
  
  for (Particle* particle = head() ; particle ; particle = particle->next() ) {
    particle->real_location(x, y, z);
    
    r_v1 = Gems::instance()->_air_db->get_value(x, y, z, 4, day(),
					       month(), year(), time());

    k1 = r_v1->get_value();
    
    if (k1 == nil) {
      fprintf(stderr, "QueryParticleTracker::move_particles()\n");
      fprintf(stderr, "\tHour does not exist in database.\n");
      stop();
      return;
    }

    r_v2 = Gems::instance()->_air_db->get_value(x + (ts*k1[0]/2.0),
						y + (ts*k1[1]/2.0),
						z + (ts*k1[2]/2.0),
						4, day(),
					       month(), year(),
						time() + (ts/2) );
    k2 = r_v2->get_value();
    
    if (k2 == nil) {
      fprintf(stderr, "QueryParticleTracker::move_particles()\n");
      fprintf(stderr, "\tHour does not exist in database.\n");
      stop();
      return;
    }
//printf("time()=%d\n", time());
    r_v3 = Gems::instance()->_air_db->get_value(x + (ts*k2[0]/2.0),
						y + (ts*k2[1]/2.0),
						z + (ts*k2[2]/2.0),
						4, day(),
					       month(), year(),
						time() + (ts/2) );
    k3 = r_v2->get_value();
    
    if (k3 == nil) {
      fprintf(stderr, "QueryParticleTracker::move_particles()\n");
      fprintf(stderr, "\tHour does not exist in database.\n");
      stop();
      return;
    }

    r_v4 = Gems::instance()->_air_db->get_value(x + (ts*k2[0]),
						y + (ts*k2[1]),
						z + (ts*k2[2]),
						4, day(),
					       month(), year(),
						time() + (ts) );
    k4 = r_v2->get_value();
    
    if (k4 == nil) {
      fprintf(stderr, "QueryParticleTracker::move_particles()\n");
      fprintf(stderr, "\tHour does not exist in database.\n");
      stop();
      return;
    }

//    printf("time =%d ts=%d h=%f\n",time(),ts,h);
//    printf("x=%f, y=%f, z=%f\n",x,y,z);
//    printf("k1: x=%f, y=%f, z=%f\n",k1[0],k1[1],k1[2]);
//    printf("k2: x=%f, y=%f, z=%f\n",k2[0],k2[1],k2[2]);
//    printf("k3: x=%f, y=%f, z=%f\n",k3[0],k3[1],k3[2]);
//    printf("k4: x=%f, y=%f, z=%f\n",k4[0],k4[1],k4[2]);

    x += (1.0/6.0) * ts * (k1[0] + (2.0 * k2[0]) + (2.0 * k3[0]) + k4[0]);
    y += (1.0/6.0) * ts * (k1[1] + (2.0 * k2[1]) + (2.0 * k3[1]) + k4[1]);
    z += (1.0/6.0) * ts * (k1[0] + (2.0 * k2[0]) + (2.0 * k3[0]) + k4[2]) / 100.0;
//    printf("x=%f, y=%f, z=%f\n\n",x,y,z);
    // hack - need to use stored _real_height and _real_ceiling
    if (z > 1100.0) {
//      printf("\tsetting z to 0\n");
      z = 0.0;
    } else if (z < 0.0) {
//      printf("\tsetting z to 1100\n");
      z = 1100.0;
    }

//    printf("\tParticle moving to Real x=%2f y=%2f z=%2f\n", x, y, z);    
    particle->move(move_step(), x, y, z);

    delete r_v1;
    delete r_v2;
    delete r_v3;
    delete r_v4;
  }
}

void QueryParticleTracker::date(int month, int day, int year)
{
  Simulation::date(month, day, year);
  
  printf("QueryPartcileTracker::data(month, day, year)\n");
  printf("\tmonth=%d day=%d year=%d\n", month, day, year);

  struct day_info* day_info = 
	Gems::instance()->_air_db->get_day_info(day, month, year);

  printf("\torig_east=%f orig_north=%f\n", day_info->orig_east, day_info->orig_north);

  Coord left = day_info->orig_east;
  Coord bottom = day_info->orig_north;
  Coord right = left + day_info->grid_width * day_info->grid_width_size;
  Coord top = bottom + day_info->grid_length * day_info->grid_length_size;

  Coord floor = day_info->grid_height[0];
  Coord ceiling = day_info->grid_height[day_info->grid_height_size - 1];
  
  printf("\tReal top=%f bottom=%f left=%f right=%f floor=%f ceiling=%f\n", top, bottom, left, right, floor, ceiling);

  update_real_size(top, bottom, left, right, floor, ceiling);

}
   

