#include <InterViews/coord.h>
#include <stdio.h>

/*
 * poly_clip
 */ 

int poly_clip(Coord box_x1, Coord box_y1,  Coord box_x2, Coord box_y2,
	     Coord* poly_x, Coord* poly_y, int count)
{

  /* The average of the box */
  long x = (long) (box_x1 + box_x2) / 2;
  long y = (long) (box_y1 + box_y2) / 2;

  int nc, sh, nsh, i;
  long px, py, qx, qy;
  int first=0, second=0, slope;
    
  if (count < 1)
    return(0);

//  printf("polyclip\n");
//  printf("\tx=%d y=%d\n", x, y);
//  for (i = 0 ; i < count ; ++i)
//    printf("\t%d x=%f y=%f\n", i, poly_x[i], poly_y[i]);
    
  nc = 0;
  px = (long) poly_x[first];
  py = (long) poly_y[first];
  sh = (y > py); 

  for (i = 0; i < count ; i++) {

    if (second < (count - 1))
      ++second;
    else 
      second = 0;

    qx = (long) poly_x[second];
    qy =(long)  poly_y[second];

    nsh = (y > qy);
    if (nsh != sh) { /*is y between the two points(y-wise that is)*/
      if (( x < px) && (x < qx))
	nc++;
      else if ((x < px) || (x < qx)) {
	slope = (int) ((qx - px) / (qy - py)); /*yeah, it is inverse*/
	if ((px -x) > (py -y) * slope )
	  nc++;
      }
    }
    sh = nsh;
    first = second;
    px = (long) poly_x[first];
    py = (long) poly_y[first];
  }
  return(nc & 1);
}

/*
 * line_clip
 */ 

int rc_lineclip (int* srow, int* scol, int* erow, int* ecol, int mbrsr, int mbrsc, int mbrer, int mbrec);

int ulrc_lineclip (unsigned long *srow, unsigned long *scol, unsigned long *erow, unsigned long *ecol, unsigned long mbrsr, unsigned long mbrsc, unsigned long mbrer, unsigned long mbrec);

int drc_lineclip (double* dsrow, double* dscol, double* derow, double* decol, int mbrsr, int mbrsc, int mbrer, int mbrec);

int line_clip(Coord box_x1, Coord box_y1,  Coord box_x2, Coord box_y2,
	      Coord line_x1, Coord line_y1, Coord line_x2,Coord line_y2)
{
    unsigned long r1,c1,r2,c2;
    
    r1 = (unsigned long) line_y1;
    c1 = (unsigned long) line_x1;
    r2 = (unsigned long) line_y2;
    c2 = (unsigned long) line_x2;

    // hack to make clicking be a little less sensitive so you
    // don't have to click right on the line.  What should be done
    // is to have a glyph which contains lines intercept a button click, 
    // create a new hit with an event whose are is a rectangle centered around 
    // the point of the click(instead of just the point),
    // then call pick on the body of the glyph, then get the hadnler from the
    // returned hit and call handler->event(e) on the returned hadnler.
    //
    Coord clip_offset = 2.0;
    if ((box_x1 == box_x2) && (box_y1 == box_y2)) {
      box_x1 -= clip_offset;
      box_y1 -= clip_offset;
      box_x2 += clip_offset;
      box_y2 += clip_offset;
    }

    return ulrc_lineclip(&r1,&c1,&r2,&c2,
			 (unsigned long) box_y1,
			 (unsigned long) box_x1,
			 (unsigned long) box_y2,
			 (unsigned long) box_x2);
}

/*********************************************************************
 * HISTORY
 * 22-Oct-91  Jefferey Shufelt (js) at The Digital Mapping Laboratory
 *	School of Computer Science at Carnegie-Mellon University
 *	Modified version of lineclipping code written by Mike Fox of
 *	the Digital Mapping Laboratory, 7/16/91.  Removed CS environment
 *	dependencies and MAPS lab hacks.
 *
 * 27-Oct-91  Erik Riedel (er1p) at Carnegie Mellon University
 *      Modified to work with unsigned longs for use with
 *      Interactive Pittsburgh
 *********************************************************************
 */

/* bit codes for line endpoints -- these are arbitrary as long as each code
   occupies a different (single) bit position and if the routines which handle
   the lines take the coordinate system into account. These bitcodes are
   consistent with Foley and Van Dam (pg. 146-). */

#define LEFT   01	/* 0001 */
#define RIGHT  02	/* 0010 */
#define BOTTOM 04	/* 0100 */
#define TOP    0x8	/* 1000 */

#define CLIP_RC_CODE(code,x,y,mbrx1,mbry1,mbrx2,mbry2) \
{ \
	code = 0; \
	if (x < mbrx1) code = TOP; \
	else if (x > mbrx2) code = BOTTOM; \
	if (y < mbry1) code |= LEFT; \
	else if (y > mbry2) code |= RIGHT; \
}

#define ROUND(x)     (((x)>0.0)?((int)((x)+0.5)):((int)((x)-0.5)))
#define ROUNDUL(x)   (((x)>0.0)?((unsigned long)((x)+0.5)):((int)((x)-0.5)))
/* --------------------------------------------------------------------------
   rc_lineclip -- clip a line, endpoints are passed and returned as integers,
   mbr coordinates are ints. 

   Returns: 0 if the line was (completely) outside the mbr
            1 if the line was in (or on) the mbr
            2 if the line had to be clipped (part outside mbr). */

int rc_lineclip (int* srow, int* scol, int* erow, int* ecol, int mbrsr, int mbrsc, int mbrer, int mbrec)
{
  int c1, c2;
  double x, y;
  double dx, dy;
  double dsrow, dscol, derow, decol;

  dsrow = (double) *srow;
  dscol = (double) *scol;
  derow = (double) *erow;
  decol = (double) *ecol;

  CLIP_RC_CODE (c1, dsrow, dscol, mbrsr, mbrsc, mbrer, mbrec);
  CLIP_RC_CODE (c2, derow, decol, mbrsr, mbrsc, mbrer, mbrec);

  /* line trivially eliminated if both endpoints in same region outside mbr */
  if(c1 & c2) return(0); /* endpoints not changed */

  /* get these once */
  dx = derow - dsrow;
  dy = decol - dscol;

  /* line trivially accepted if both endpoints in the mbr */	
  if(!(c1 | c2)) return(1); /* endpoints not changed */

  /* non-trivial case: reduce line to a trivial case */
  while (c1 | c2) {
    if (c1) { /* move c1 to intersection with mbr line */
      if (c1 & LEFT) {
        x = dsrow + ((mbrsc - dscol)*dx)/dy;
        y = mbrsc;
      } else if (c1 & RIGHT) {
        x = dsrow + ((mbrec - dscol)*dx)/dy;
        y = mbrec;
      } else if (c1 & BOTTOM) {
        y = dscol + ((mbrer - dsrow)*dy)/dx;
        x = mbrer;
      } else if (c1 & TOP) {
        y = dscol + ((mbrsr - dsrow)*dy)/dx;
        x = mbrsr;
      }
      dsrow = x;
      dscol = y;
      CLIP_RC_CODE (c1, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if (c1 & c2) {
        *srow = ROUND(dsrow);
        *scol = ROUND(dscol);
        *erow = ROUND(derow);
        *ecol = ROUND(decol);
        return (0);
      }
    }

    if (c2) {	/* more c2 to intersection with mbr line */
      if (c2 & LEFT) {
        x = derow + ((mbrsc - decol)*dx)/dy;
        y = mbrsc;
      } else if (c2 & RIGHT) {
        x = derow + ((mbrec - decol)*dx)/dy;
        y = mbrec;
      } else if (c2 & BOTTOM) {
        y = decol + ((mbrer - derow)*dy)/dx;
        x = mbrer;
      } else if (c2 & TOP) {
        y = decol + ((mbrsr - derow)*dy)/dx;
        x = mbrsr;
      }

      derow = x;
      decol = y;
      CLIP_RC_CODE (c2, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if (c1 & c2) {
        *srow = ROUND(dsrow);
        *scol = ROUND(dscol);
        *erow = ROUND(derow);
        *ecol = ROUND(decol);
        return (0);
      }
    }
  }
  /* line has to be in mbr if we get here, and it was clipped */
  *srow = ROUND(dsrow);
  *scol = ROUND(dscol);
  *erow = ROUND(derow);
  *ecol = ROUND(decol);
  return(2);
}

/* --------------------------------------------------------------------------
   ulrc_lineclip -- clip a line, endpoints are passed and returned as 
   unsigned longs, mbr coordinates are unsigned longs. 

   Returns: 0 if the line was (completely) outside the mbr
            1 if the line was in (or on) the mbr
            2 if the line had to be clipped (part outside mbr). */

int ulrc_lineclip (unsigned long *srow, unsigned long *scol, unsigned long *erow, unsigned long *ecol, unsigned long mbrsr, unsigned long mbrsc, unsigned long mbrer, unsigned long mbrec)
{
  int c1, c2;
  double x, y;
  double dx, dy;
  double dsrow, dscol, derow, decol;

  dsrow = (double) *srow;
  dscol = (double) *scol;
  derow = (double) *erow;
  decol = (double) *ecol;

  CLIP_RC_CODE (c1, dsrow, dscol, mbrsr, mbrsc, mbrer, mbrec);
  CLIP_RC_CODE (c2, derow, decol, mbrsr, mbrsc, mbrer, mbrec);

  /* line trivially eliminated if both endpoints in same region outside mbr */
  if(c1 & c2) return(0); /* endpoints not changed */

  /* get these once */
  dx = derow - dsrow;
  dy = decol - dscol;

  /* line trivially accepted if both endpoints in the mbr */	
  if(!(c1 | c2)) return(1); /* endpoints not changed */

  /* non-trivial case: reduce line to a trivial case */
  while (c1 | c2) {
    if (c1) { /* move c1 to intersection with mbr line */
      if (c1 & LEFT) {
        x = dsrow + ((mbrsc - dscol)*dx)/dy;
        y = mbrsc;
      } else if (c1 & RIGHT) {
        x = dsrow + ((mbrec - dscol)*dx)/dy;
        y = mbrec;
      } else if (c1 & BOTTOM) {
        y = dscol + ((mbrer - dsrow)*dy)/dx;
        x = mbrer;
      } else if (c1 & TOP) {
        y = dscol + ((mbrsr - dsrow)*dy)/dx;
        x = mbrsr;
      }
      dsrow = x;
      dscol = y;
      CLIP_RC_CODE (c1, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if (c1 & c2) {
        *srow = ROUNDUL(dsrow);
        *scol = ROUNDUL(dscol);
        *erow = ROUNDUL(derow);
        *ecol = ROUNDUL(decol);
        return (0);
      }
    }

    if (c2) {	/* more c2 to intersection with mbr line */
      if (c2 & LEFT) {
        x = derow + ((mbrsc - decol)*dx)/dy;
        y = mbrsc;
      } else if (c2 & RIGHT) {
        x = derow + ((mbrec - decol)*dx)/dy;
        y = mbrec;
      } else if (c2 & BOTTOM) {
        y = decol + ((mbrer - derow)*dy)/dx;
        x = mbrer;
      } else if (c2 & TOP) {
        y = decol + ((mbrsr - derow)*dy)/dx;
        x = mbrsr;
      }

      derow = x;
      decol = y;
      CLIP_RC_CODE (c2, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if (c1 & c2) {
        *srow = ROUNDUL(dsrow);
        *scol = ROUNDUL(dscol);
        *erow = ROUNDUL(derow);
        *ecol = ROUNDUL(decol);
        return (0);
      }
    }
  }
  /* line has to be in mbr if we get here, and it was clipped */
  *srow = ROUNDUL(dsrow);
  *scol = ROUNDUL(dscol);
  *erow = ROUNDUL(derow);
  *ecol = ROUNDUL(decol);
  return(2);
}

/* --------------------------------------------------------------------------
   drc_lineclip -- clip a line, endpoints are passed and returned as doubles,
   mbr coordinates are ints. 

   Returns: 0 if the line was (completely) outside the mbr
            1 if the line was in (or on) the mbr
            2 if the line had to be clipped (part outside mbr). */

int drc_lineclip (double* dsrow, double* dscol, double* derow, double* decol, int mbrsr, int mbrsc, int mbrer, int mbrec)
{
  int c1, c2;
  double x, y, dx, dy;

  CLIP_RC_CODE (c1, *dsrow, *dscol, mbrsr, mbrsc, mbrer, mbrec);
  CLIP_RC_CODE (c2, *derow, *decol, mbrsr, mbrsc, mbrer, mbrec);

  /* line trivially eliminated if both endpoints in same region outside mbr */
  if (c1 & c2) return(0);

  /* get these once */
  dx = *derow - *dsrow;
  dy = *decol - *dscol;

  if(!(c1 | c2)) return(1);

  /* line MIGHT intersect mbr (lies inside mbr if c1=c2=0) */
  while (c1 | c2) {
    if (c1) { /* move c1 to intersection with mbr line */
      if (c1 & LEFT) {
        x = *dsrow + ((mbrsc - *dscol)*dx)/dy;
        y = mbrsc;
      } else if (c1 & RIGHT) {
        x = *dsrow + ((mbrec - *dscol)*dx)/dy;
        y = mbrec;
      } else if (c1 & BOTTOM) {
        y = *dscol + ((mbrer - *dsrow)*dy)/dx;
        x = mbrer;
      } else if (c1 & TOP) {
        y = *dscol + ((mbrsr - *dsrow)*dy)/dx;
        x = mbrsr;
      }

      *dsrow = x;
      *dscol = y;
      CLIP_RC_CODE (c1, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if(c1 & c2) return (0);
    }

    if (c2) {	/* more c2 to intersection with mbr line */
      if (c2 & LEFT) {
        x = *derow + ((mbrsc - *decol)*dx)/dy;
        y = mbrsc;
      }	else if (c2 & RIGHT) {
        x = *derow + ((mbrec - *decol)*dx)/dy;
        y = mbrec;
      } else if (c2 & BOTTOM) {
        y = *decol + ((mbrer - *derow)*dy)/dx;
        x = mbrer;
      } else if (c2 & TOP) {
        y = *decol + ((mbrsr - *derow)*dy)/dx;
        x = mbrsr;
      }

      *derow = x;
      *decol = y;
      CLIP_RC_CODE (c2, x, y, mbrsr, mbrsc, mbrer, mbrec);

      /* check for trivial elimination */
      if(c1 & c2) return (0);
    }
  }
  /* line has to be in mbr if we get here, and it was clipped */
  return(2);
}
