/**************************************************************************
 * 
 * Class:  Writer implementation
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk/writer.h>
#include <Dispatch/rpchdr.h>
#include <Dispatch/rpcstream.h>



/**************************************************************************
 * 
 * Constructors.
 *
 **************************************************************************/

Writer::Writer(const char* host, int port) : RpcWriter(host,port,false,true) {}
Writer::Writer(int fd) : RpcWriter(fd,false,true) {}
Writer::Writer(rpcstream* server) : RpcWriter(server) {}



/**************************************************************************
 * 
 * Send a message containing a integer code and an optional string.
 *
 **************************************************************************/

void Writer::sendMsg(int code, char *msg) {
  if(msg==nil) 
    msg = "  ";
  server() << RpcHdr(this, code) << msg << flush;
}
