/****************************************************************************
 *
 * Class:  StringBrowser implementation
 * Author: Mark Roseman
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 06/08/92 MR        initial version
 * 09/13/92 MR        brought up to date with 3.1b2 file browser interface
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk-ui/strbrowser.h>
#include <stdio.h>
#include <IV-look/choice.h>
#include <IV-look/kit.h>



/****************************************************************************
 *
 * Constructor.
 * 
 ****************************************************************************/

StringBrowser::StringBrowser(WidgetKit* kit, Action* a, Action* sel) : 
      FileBrowser(kit,a,nil), selAction_(sel), kit_(kit) 
{}


/****************************************************************************
 *
 * Append a string to the browser.  
 * 
 ****************************************************************************/

void StringBrowser::Append(const char* s) {
  TelltaleState* t = new TelltaleState(TelltaleState::is_enabled);
  append_selectable(t);
  Glyph* label = kit_->label( s );
  append( new ChoiceItem( t, label, kit_->bright_inset_frame(label) ));
  refresh();
}


/****************************************************************************
 *
 * Append a glyph to the browser.  
 * 
 ****************************************************************************/

void StringBrowser::Append(Glyph* g) {
  TelltaleState* t = new TelltaleState(TelltaleState::is_enabled);
  append_selectable(t);
  append( new ChoiceItem( t, g, kit_->bright_inset_frame(g) ));
  refresh();
}


/****************************************************************************
 *
 * Remove a string from the browser.
 * 
 ****************************************************************************/

void StringBrowser::Remove(int index) {
  remove_selectable(index);
  remove(index);
}


/****************************************************************************
 *
 * Return the number of strings in the browser.
 * 
 ****************************************************************************/

int StringBrowser::Count() {
  return count();
}


/****************************************************************************
 *
 * Delete every item in the browser.
 * 
 ****************************************************************************/

void StringBrowser::Clear() {
  select(-1);
  GlyphIndex n = count();
  for(GlyphIndex i = 0; i < n; i++) {
    remove_selectable(0);
    remove(0);
  }
}

/****************************************************************************
 *
 * Select a particular string in the browser.
 * 
 ****************************************************************************/

void StringBrowser::select(GlyphIndex idx) {
  FileBrowser::select(idx);
  if(selAction_ != nil) 
    selAction_->execute();
}

