/****************************************************************************
 *
 * Class:  Shell implementation
 * Author: Mark Roseman
 * 
 * This class manages a Unix shell process, using an emulator and a
 * text buffer.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk-ui/shell.h>
#include <Dispatch/dispatcher.h>
#include <stdio.h>
#include <string.h>
#include <osfcn.h>
#include <IV-look/kit.h>
#include <gk-ui/emulator.h>
#include <gk-ui/text.h>
#include <InterViews/event.h>
#include <sys/termios.h>

extern int open_pty_channel(char *,FILE **, FILE **);


/**************************************************************************
 * 
 * Create a new shell,wrapping an emulator up with a text buffer.  open
 * up a pty channel which connects us to the actual shell process
 *
 **************************************************************************/

Shell::Shell(WidgetKit* kit) : InputHandler(nil, kit->style()), IOHandler() {
  int tmp;
  TextBuf* tb = new TextBuf(kit, 80,24);
  em_ = new Emulator( tb);
  if ((tmp = open_pty_channel("/bin/csh", &in_file, &out_file)) == -1) 
    printf("oops on open_pty_channel\n");
  else 
    Dispatcher::instance().link(in_file->_file, Dispatcher::ReadMask, this);
  body(tb);
}

extern int errno;

/**************************************************************************
 * 
 * we've received input from our shell process, send it to the emulator
 *
 **************************************************************************/

int Shell::inputReady(int /* fd */) 
{
  char s[1024];
  int num;
  
  num = read(in_file->_file, s, 1024);	
  if((num>0) && (*s != 0)) {
    em_->Write(s,num);
  }
  return 0;
}

/**************************************************************************
 * 
 * keystroke from the user, send it to the shell process
 *
 **************************************************************************/

void Shell::keystroke(const Event& ev) 
{
  char s[10];
  if(ev.mapkey(s,sizeof(s)) >0) {
    s[1] = 0;
    fputc( s[0], out_file );
    fflush(out_file);
  }
}




