/****************************************************************************
 *
 * Classes: OpenRegClient
 * Author:  Mark Roseman
 *
 * Do an "open" registrar client.  Such a client assumes anyone can join
 * any conference.  Our interface is provided by the class RegClientDisplay.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/22/92 MR        initial version
 * 08/14/92 MR        clean up
 * 09/20/92 MR        updated to use host/port to find registrar
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __oprc_h
#define __oprc_h

#include <gk-reg/regclient.h>

class OpenRegClient : public RegistrarClient {
public:
  
  /*
  ** constructor 
  */
  OpenRegClient(const char* host, int port, class Coordinator*);
  void addDisplay(class RegClientDisplay*);

  /*
  ** hook from coordinator
  */
  virtual void userLeft(int conf_id, int user_id);

protected:
  friend class RegClientDisplay;
  /*
  ** hooks activated via info from registrar
  */
  virtual void foundNewConference(AttributeList*);
  virtual void foundDeletedConference(int);
  virtual void foundNewUser(AttributeList*);
  virtual void foundDeletedUser(int,int);

  /*
  ** hooks activated via user interface
  */
  void requestNewConference(char*, char*);
  void requestLeaveConference(int);
  void requestJoinConference(int);
  void requestViewConference(int);

  /*
  ** mostly hacky instance variables -- should clean up
  */
  boolean newConfPending;
  boolean myselfJoinPending;
  class RegClientDisplay* display_;
};


#endif
