/**************************************************************************
 * 
 * Class:  Writer implementation
 * Author: Mark Roseman
 *
 * A simple front end to the RpcWriter class -- the main enhancement is
 * a routine to send standard GroupKit type messages.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 * 08/14/92 MR        clean up
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __writer_h
#define __writer_h

#include <Dispatch/rpcwriter.h>

class Writer : public RpcWriter {
public:

  /*
  ** constructor
  */
  Writer(const char* host, int port);
  Writer(int fd);
  Writer(rpcstream* server);

  /*
  ** send a message
  */
  void sendMsg(int msg_id_num, char *msg);
};

#endif
