/****************************************************************************
 *
 * Class:  Tabular
 * Author: Mark Roseman
 * 
 * This class manages a table of glyphs arranged in rows and columns, where
 * the size of each row or column is the maximum of the sizes of all elements
 * in the row or column.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __tabular_h
#define __tabular_h

#include <InterViews/monoglyph.h>

class Tabular : public MonoGlyph {
public:
  Tabular(int x=1, int y=1);
  void insert_row(int y);
  void insert_col(int x);
  void delete_row(int y);
  void delete_col(int x);
  void replace( int x, int y, Glyph* g);
  Glyph* item ( int x, int y);
  int rows();
  int cols();
protected:
  void width( int x );
  void height( int y );
  void recalc();

  int rows_;
  int cols_;
  class WidgetKit* kit_;
  class LayoutKit* layout_;
};

#endif
