/***************************************************************************
 *
 * Class:  Coordinator
 * Author: Mark Roseman
 * 
 * This class serves to mediate the interaction between the registrar
 * client and one or more conferences.  The Coordinator handles
 * requests to create conferences, as well as delegating requests
 * to delete conferences, and join and remove users to the actual
 * conferences.  
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/19/92 MR        initial version
 * 05/29/92 MR        majorly changed to support conferences as separate 
 *                    processes..
 * 09/17/92 MR        added callback for reader connection close
 * 09/20/92 MR        added hook back to the registrar client
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __coordinator_h
#define __coordinator_h


#include <Dispatch/rpcpeer.h>
class rpcstream;

#include <gk/attrlist.h>

class Coordinator : public RpcPeer {
public:
  Coordinator(class Style* style);
  ~Coordinator();

  // connection ops

  virtual void createReaderAndWriter(int fd);  // conns from our conferences

  // userops

  virtual boolean createConference(AttributeList*);
  void deleteConference(int);
  void joinTo(AttributeList*);
  void deleteUser(int,int);
  void setLocalInfo(AttributeList*);

  // hooks for address resolution for conferences

  void addrReq(char *s, class Connection*);
  void addrResp(char *s);

  class RegistrarClient* rc_;

protected:
  class ConfTbl* confs_;
  class MsgQTbl* pending_;
  class UIDTbl* uids_;
  void info_callback(char *, class Connection*);
  void closeCallback(class CallbackRpcReader*, int);
  void toConf(int, class StrMsgSender*);
  class Style* style_;
};

#endif









