#!perl -T
use 5.010;
use strict;
use warnings;
use Test::More;
use Test::Rsyslog();
use Sys::Syslog();

plan tests => 10;

my $rsyslog = Test::Rsyslog->new();
ok($rsyslog, "Created Test Rsyslog object");

if ($Sys::Syslog::VERSION ge 0.28) {
	Sys::Syslog::setlogsock({ type => 'unix', path => $rsyslog->socket_path() });
} else {
	Sys::Syslog::setlogsock('unix', $rsyslog->socket_path());
}
Sys::Syslog::openlog($0 . '[' . $$ . ']','cons','LOG_LOCAL7');
my $plain = 'This is a test message';
ok(Sys::Syslog::syslog('info|LOG_LOCAL7', $plain), "Sent '$plain' to rsyslog");
Sys::Syslog::closelog();
$rsyslog->stop();
my @messages = $rsyslog->find($plain);
ok(scalar @messages == 1, "Found 1 matching log message");
my $quoted = quotemeta $plain;
ok($messages[0] =~ /$quoted/smx, q[Found '] . (join q[, ], @messages) . q[']);
$rsyslog->start();
Sys::Syslog::openlog($0 . '[' . $$ . ']','cons','LOG_LOCAL0');
my $unicode = 'This is a ' . (chr 1606) . ' unicode ' . (chr 29399) . ' message';
my $copy = $unicode;
my $encoded = Encode::encode('UTF-8', $copy, 1);
ok(Sys::Syslog::syslog('LOG_INFO|LOG_LOCAL0', $encoded), "Sent '$encoded' to rsyslog");
Sys::Syslog::closelog();
$rsyslog->stop();
@messages = $rsyslog->find($unicode);
ok(scalar @messages == 1, "Found 1 matching log message");
$quoted = quotemeta $unicode;
ok($messages[0] =~ /$quoted/smx, q[Found '] . (join q[, ], map { Encode::encode('UTF-8', $_, 1) } @messages) . q[']);
$rsyslog->start();
Sys::Syslog::openlog($0 . '[' . $$ . ']','cons','LOG_USER');
my $special = "This is a \x05message\r\n with special @\b characters" . (join q[ ], map { chr $_ } 0 .. 40);
ok(Sys::Syslog::syslog('LOG_INFO|LOG_USER',$special), 'Sent a message containing every known special character to rsyslog');
Sys::Syslog::closelog();
$rsyslog->stop();
@messages = $rsyslog->find($special);
ok(scalar @messages == 1, "Found 1 matching log message");
ok($messages[0] =~ /special/smx, q[Found '] . (join q[, ], @messages) . q[']);
