package eval;

our $DATE = '2019-10-19'; # DATE
our $VERSION = '0.002'; # VERSION

sub import {
    my $class = shift;
    my $code = join ",", @_;
    return unless length $code;
    warn "eval.pm: Eval'ing: $code\n" if $ENV{DEBUG};
    eval $code;
    die if $@;
}

1;
# ABSTRACT: Eval code

__END__

=pod

=encoding UTF-8

=head1 NAME

eval - Eval code

=head1 VERSION

This document describes version 0.002 of eval (from Perl distribution eval), released on 2019-10-19.

=head1 SYNOPSIS

Use in one-liner or in PERL5OPT:

 % perl -Meval='$Carp::MaxArgLen = 1000' script.pl

 % DEBUG=1 PERL5OPT='-Meval=$Carp::MaxArgLen=1000' script.pl
 eval.pm: Eval'ing: $Carp::MaxArgLen=1000

=head1 DESCRIPTION

This pragma lets you run some Perl code before running your script. Some other
ways to accomplish the same include:

=over

=item * creating F<$Config{sitelib}/sitecustomize.pl>

See L<perlrun>.

=item * putting your code in a module and load it using C<-m> or C<-M>

For example, you put your code in F<lib/Foo.pm> and run your script using:

 % PERL5OPT="-Ilib -MFoo" script.pl

=item * C<do>

 % perl -e'$Carp::MaxArgLen = 1000; do "script.pl"'

=back

Some caveats:

=over

=item * No whitespace in code in PERL5OPT

Space is used to separate perl options in PERL5OPT, so you can't do:

 % PERL5OPT='-Meval=$Carp::MaxArgLen = 1000' script.pl

but you can do:

 % PERL5OPT='-Meval=$Carp::MaxArgLen=1000' script.pl

To help you see what code is being eval'ed, set C<DEBUG> to true:

 % DEBUG=1 PERL5OPT='-Meval=$Carp::MaxArgLen=1000' script.pl
 eval.pm: Eval'ing: $Carp::MaxArgLen=1000

=back

=head1 ENVIRONMENT

=head2 DEBUG

Bool. If set to true, will show what code is being eval'ed.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/eval>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-eval>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=eval>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
