/*
 * Decompiled with CFR 0.152.
 */
package gma.gcalign;

import gma.gcalign.VAL_TABLE;
import gma.gcalign.align_core;
import gma.gcalign.step_table;
import gma.gcalign.strategy;
import gma.gcalign.strategy_delta;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class GCalign {
    public static final int EXIT_ERROR_CODE = 1;
    public static final int MAX_LINE_LENGTH = 7;
    static String program_name;
    static int verbose;
    align_core align = new align_core();

    public List gcalign(String[] args) {
        StringTokenizer st;
        String soft_delimiter = null;
        String sInput = null;
        Object stdout = null;
        strategy_delta DELTA1 = new strategy_delta();
        strategy newstrategy = new strategy();
        Object input_file = null;
        int hsize = 0;
        int vsize = 0;
        int item1 = 0;
        int item2 = 0;
        align_core align = new align_core();
        step_table alignment = new step_table();
        VAL_TABLE valtable1 = null;
        VAL_TABLE valtable2 = null;
        if (args.length <= 1) {
            System.out.println("Usage:");
            System.out.println(" c: java GCalign [-v] [-V] -d <delim-string> -i <input>");
            System.exit(1);
        }
        program_name = args[0];
        int iNextArg = 0;
        while (args.length > iNextArg + 1) {
            if (args[iNextArg].equals("-d")) {
                soft_delimiter = args[++iNextArg];
                ++iNextArg;
                continue;
            }
            if (args[iNextArg].equals("-v") || args[iNextArg].equals("-V")) {
                verbose = 1;
                System.out.println("setting verbose");
                ++iNextArg;
                continue;
            }
            if (!args[iNextArg].equals("-i")) continue;
            sInput = args[++iNextArg];
            ++iNextArg;
        }
        if (verbose != 0) {
            System.out.println("Parced Input parameters: soft_delimeter=" + soft_delimiter + "; sInput=" + sInput);
        }
        if ((st = new StringTokenizer(sInput, soft_delimiter)).countTokens() != 2) {
            System.out.println("Missing soft_delimiter: " + sInput);
            System.exit(1);
        }
        if (st.hasMoreTokens()) {
            valtable1 = new VAL_TABLE(st.nextToken());
            if (verbose != 0) {
                System.out.println("table1:");
                valtable1.print();
            }
        }
        if (st.hasMoreTokens()) {
            valtable2 = new VAL_TABLE(st.nextToken());
        }
        if (verbose != 0) {
            System.out.println("table1:");
            valtable1.print();
            System.out.println("table2:");
            valtable2.print();
        }
        alignment = align.align_values(valtable1, valtable2, newstrategy, item1, item2);
        ArrayList<String> alignments = new ArrayList<String>();
        for (int i = alignment.length - 1; i >= 0; --i) {
            hsize = strategy_delta.item1[alignment.STEP[i].sval];
            vsize = strategy_delta.item2[alignment.STEP[i].sval];
            String alignmentString = new String("" + hsize + " <=> " + vsize);
            alignments.add(alignmentString);
        }
        return alignments;
    }

    public static void main(String[] args) {
        GCalign gcalign = new GCalign();
        List alignments = gcalign.gcalign(args);
        Iterator iter = alignments.iterator();
        while (iter.hasNext()) {
            String alignmentString = (String)iter.next();
            System.out.println(alignmentString);
        }
        System.exit(0);
    }

    static {
        verbose = 0;
    }
}

