package Data::Object::ClassHas;

use 5.014;

use strict;
use warnings;

use parent 'Data::Object::Attributes';

our $VERSION = '2.00'; # VERSION

1;

=encoding utf8

=head1 NAME

Data::Object::ClassHas

=cut

=head1 ABSTRACT

Attribute Builder for Data-Object Class

=cut

=head1 SYNOPSIS

  package main;

  # use Data::Object::Class;

  use Data::Object::ClassHas;

  1;

=cut

=head1 DESCRIPTION

This package provides options for defining class attributes.

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Data::Object::Attributes>

=cut

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the L<"license
file"|https://github.com/iamalnewkirk/data-object-classhas/blob/master/LICENSE>.

=head1 PROJECT

L<Wiki|https://github.com/iamalnewkirk/data-object-classhas/wiki>

L<Project|https://github.com/iamalnewkirk/data-object-classhas>

L<Initiatives|https://github.com/iamalnewkirk/data-object-classhas/projects>

L<Milestones|https://github.com/iamalnewkirk/data-object-classhas/milestones>

L<Contributing|https://github.com/iamalnewkirk/data-object-classhas/blob/master/CONTRIBUTE.md>

L<Issues|https://github.com/iamalnewkirk/data-object-classhas/issues>

=cut
